/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class FutureRecordMetadataTest {
    private final MockTime time = new MockTime();

    @Test
    public void testFutureGetWithSeconds() throws ExecutionException, InterruptedException, TimeoutException {
        ProduceRequestResult produceRequestResult = this.mockProduceRequestResult();
        FutureRecordMetadata future = this.futureRecordMetadata(produceRequestResult);
        ProduceRequestResult chainedProduceRequestResult = this.mockProduceRequestResult();
        future.chain(this.futureRecordMetadata(chainedProduceRequestResult));
        future.get(1L, TimeUnit.SECONDS);
        ((ProduceRequestResult)Mockito.verify((Object)produceRequestResult)).await(1L, TimeUnit.SECONDS);
        ((ProduceRequestResult)Mockito.verify((Object)chainedProduceRequestResult)).await(1000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testFutureGetWithMilliSeconds() throws ExecutionException, InterruptedException, TimeoutException {
        ProduceRequestResult produceRequestResult = this.mockProduceRequestResult();
        FutureRecordMetadata future = this.futureRecordMetadata(produceRequestResult);
        ProduceRequestResult chainedProduceRequestResult = this.mockProduceRequestResult();
        future.chain(this.futureRecordMetadata(chainedProduceRequestResult));
        future.get(1000L, TimeUnit.MILLISECONDS);
        ((ProduceRequestResult)Mockito.verify((Object)produceRequestResult)).await(1000L, TimeUnit.MILLISECONDS);
        ((ProduceRequestResult)Mockito.verify((Object)chainedProduceRequestResult)).await(1000L, TimeUnit.MILLISECONDS);
    }

    private FutureRecordMetadata futureRecordMetadata(ProduceRequestResult produceRequestResult) {
        return new FutureRecordMetadata(produceRequestResult, 0, -1L, 0, 0, (Time)this.time);
    }

    private ProduceRequestResult mockProduceRequestResult() throws InterruptedException {
        ProduceRequestResult mockProduceRequestResult = (ProduceRequestResult)Mockito.mock(ProduceRequestResult.class);
        Mockito.when((Object)mockProduceRequestResult.await(ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenReturn((Object)true);
        return mockProduceRequestResult;
    }
}

