/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.kafka.clients.admin.internals.AdminApiDriver;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.AllBrokersStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AllBrokersStrategyIntegrationTest {
    private static final long TIMEOUT_MS = 5000L;
    private static final long RETRY_BACKOFF_MS = 100L;
    private final LogContext logContext = new LogContext();
    private final MockTime time = new MockTime();

    private AdminApiDriver<AllBrokersStrategy.BrokerKey, Integer> buildDriver(AllBrokersStrategy.AllBrokersFuture<Integer> result) {
        return new AdminApiDriver((AdminApiHandler)new MockApiHandler(), result, this.time.milliseconds() + 5000L, 100L, this.logContext);
    }

    @Test
    public void testFatalLookupError() {
        AllBrokersStrategy.AllBrokersFuture result = new AllBrokersStrategy.AllBrokersFuture();
        AdminApiDriver<AllBrokersStrategy.BrokerKey, Integer> driver = this.buildDriver((AllBrokersStrategy.AllBrokersFuture<Integer>)result);
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec spec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        Assertions.assertEquals((Object)AllBrokersStrategy.LOOKUP_KEYS, (Object)spec.keys);
        driver.onFailure(this.time.milliseconds(), spec, (Throwable)new UnknownServerException());
        Assertions.assertTrue((boolean)result.all().isDone());
        TestUtils.assertFutureThrows(result.all(), UnknownServerException.class);
        Assertions.assertEquals(Collections.emptyList(), (Object)driver.poll());
    }

    @Test
    public void testRetryLookupAfterDisconnect() {
        AllBrokersStrategy.AllBrokersFuture result = new AllBrokersStrategy.AllBrokersFuture();
        AdminApiDriver<AllBrokersStrategy.BrokerKey, Integer> driver = this.buildDriver((AllBrokersStrategy.AllBrokersFuture<Integer>)result);
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec spec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        Assertions.assertEquals((Object)AllBrokersStrategy.LOOKUP_KEYS, (Object)spec.keys);
        driver.onFailure(this.time.milliseconds(), spec, (Throwable)new DisconnectException());
        List retrySpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)retrySpecs.size());
        AdminApiDriver.RequestSpec retrySpec = (AdminApiDriver.RequestSpec)retrySpecs.get(0);
        Assertions.assertEquals((Object)AllBrokersStrategy.LOOKUP_KEYS, (Object)retrySpec.keys);
        Assertions.assertEquals((long)this.time.milliseconds(), (long)retrySpec.nextAllowedTryMs);
        Assertions.assertEquals(Collections.emptyList(), (Object)driver.poll());
    }

    @Test
    public void testMultiBrokerCompletion() throws Exception {
        AllBrokersStrategy.AllBrokersFuture result = new AllBrokersStrategy.AllBrokersFuture();
        AdminApiDriver<AllBrokersStrategy.BrokerKey, Integer> driver = this.buildDriver((AllBrokersStrategy.AllBrokersFuture<Integer>)result);
        List lookupSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)lookupSpecs.size());
        AdminApiDriver.RequestSpec lookupSpec = (AdminApiDriver.RequestSpec)lookupSpecs.get(0);
        Set brokerIds = Utils.mkSet((Object[])new Integer[]{1, 2});
        driver.onResponse(this.time.milliseconds(), lookupSpec, (AbstractResponse)this.responseWithBrokers(brokerIds), Node.noNode());
        Assertions.assertTrue((boolean)result.all().isDone());
        Map brokerFutures = (Map)result.all().get();
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)2, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec requestSpec1 = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        Assertions.assertTrue((boolean)requestSpec1.scope.destinationBrokerId().isPresent());
        int brokerId1 = requestSpec1.scope.destinationBrokerId().getAsInt();
        Assertions.assertTrue((boolean)brokerIds.contains(brokerId1));
        driver.onResponse(this.time.milliseconds(), requestSpec1, null, Node.noNode());
        KafkaFutureImpl future1 = (KafkaFutureImpl)brokerFutures.get(brokerId1);
        Assertions.assertTrue((boolean)future1.isDone());
        AdminApiDriver.RequestSpec requestSpec2 = (AdminApiDriver.RequestSpec)requestSpecs.get(1);
        Assertions.assertTrue((boolean)requestSpec2.scope.destinationBrokerId().isPresent());
        int brokerId2 = requestSpec2.scope.destinationBrokerId().getAsInt();
        Assertions.assertNotEquals((int)brokerId1, (int)brokerId2);
        Assertions.assertTrue((boolean)brokerIds.contains(brokerId2));
        driver.onResponse(this.time.milliseconds(), requestSpec2, null, Node.noNode());
        KafkaFutureImpl future2 = (KafkaFutureImpl)brokerFutures.get(brokerId2);
        Assertions.assertTrue((boolean)future2.isDone());
        Assertions.assertEquals(Collections.emptyList(), (Object)driver.poll());
    }

    @Test
    public void testRetryFulfillmentAfterDisconnect() throws Exception {
        AllBrokersStrategy.AllBrokersFuture result = new AllBrokersStrategy.AllBrokersFuture();
        AdminApiDriver<AllBrokersStrategy.BrokerKey, Integer> driver = this.buildDriver((AllBrokersStrategy.AllBrokersFuture<Integer>)result);
        List lookupSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)lookupSpecs.size());
        AdminApiDriver.RequestSpec lookupSpec = (AdminApiDriver.RequestSpec)lookupSpecs.get(0);
        int brokerId = 1;
        driver.onResponse(this.time.milliseconds(), lookupSpec, (AbstractResponse)this.responseWithBrokers(Collections.singleton(brokerId)), Node.noNode());
        Assertions.assertTrue((boolean)result.all().isDone());
        Map brokerFutures = (Map)result.all().get();
        KafkaFutureImpl future = (KafkaFutureImpl)brokerFutures.get(brokerId);
        Assertions.assertFalse((boolean)future.isDone());
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec requestSpec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        driver.onFailure(this.time.milliseconds(), requestSpec, (Throwable)new DisconnectException());
        Assertions.assertFalse((boolean)future.isDone());
        List retrySpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)retrySpecs.size());
        AdminApiDriver.RequestSpec retrySpec = (AdminApiDriver.RequestSpec)retrySpecs.get(0);
        Assertions.assertEquals((long)(this.time.milliseconds() + 100L), (long)retrySpec.nextAllowedTryMs);
        Assertions.assertEquals((Object)OptionalInt.of(brokerId), (Object)retrySpec.scope.destinationBrokerId());
        driver.onResponse(this.time.milliseconds(), retrySpec, null, new Node(brokerId, "host", 1234));
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertEquals((int)brokerId, (Integer)((Integer)future.get()));
        Assertions.assertEquals(Collections.emptyList(), (Object)driver.poll());
    }

    @Test
    public void testFatalFulfillmentError() throws Exception {
        AllBrokersStrategy.AllBrokersFuture result = new AllBrokersStrategy.AllBrokersFuture();
        AdminApiDriver<AllBrokersStrategy.BrokerKey, Integer> driver = this.buildDriver((AllBrokersStrategy.AllBrokersFuture<Integer>)result);
        List lookupSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)lookupSpecs.size());
        AdminApiDriver.RequestSpec lookupSpec = (AdminApiDriver.RequestSpec)lookupSpecs.get(0);
        int brokerId = 1;
        driver.onResponse(this.time.milliseconds(), lookupSpec, (AbstractResponse)this.responseWithBrokers(Collections.singleton(brokerId)), Node.noNode());
        Assertions.assertTrue((boolean)result.all().isDone());
        Map brokerFutures = (Map)result.all().get();
        KafkaFutureImpl future = (KafkaFutureImpl)brokerFutures.get(brokerId);
        Assertions.assertFalse((boolean)future.isDone());
        List requestSpecs = driver.poll();
        Assertions.assertEquals((int)1, (int)requestSpecs.size());
        AdminApiDriver.RequestSpec requestSpec = (AdminApiDriver.RequestSpec)requestSpecs.get(0);
        driver.onFailure(this.time.milliseconds(), requestSpec, (Throwable)new UnknownServerException());
        Assertions.assertTrue((boolean)future.isDone());
        TestUtils.assertFutureThrows(future, UnknownServerException.class);
        Assertions.assertEquals(Collections.emptyList(), (Object)driver.poll());
    }

    private MetadataResponse responseWithBrokers(Set<Integer> brokerIds) {
        MetadataResponseData response = new MetadataResponseData();
        for (Integer brokerId : brokerIds) {
            response.brokers().add(new MetadataResponseData.MetadataResponseBroker().setNodeId(brokerId).setHost("host" + brokerId).setPort(9092));
        }
        return new MetadataResponse(response, ApiKeys.METADATA.latestVersion());
    }

    private class MockApiHandler
    implements AdminApiHandler<AllBrokersStrategy.BrokerKey, Integer> {
        private final AllBrokersStrategy allBrokersStrategy;

        private MockApiHandler() {
            this.allBrokersStrategy = new AllBrokersStrategy(AllBrokersStrategyIntegrationTest.this.logContext);
        }

        public String apiName() {
            return "mock-api";
        }

        public AbstractRequest.Builder<?> buildRequest(int brokerId, Set<AllBrokersStrategy.BrokerKey> keys) {
            return new MetadataRequest.Builder(new MetadataRequestData());
        }

        public AdminApiHandler.ApiResult<AllBrokersStrategy.BrokerKey, Integer> handleResponse(Node broker, Set<AllBrokersStrategy.BrokerKey> keys, AbstractResponse response) {
            return AdminApiHandler.ApiResult.completed((Object)keys.iterator().next(), (Object)broker.id());
        }

        public AdminApiLookupStrategy<AllBrokersStrategy.BrokerKey> lookupStrategy() {
            return this.allBrokersStrategy;
        }
    }
}

