/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.apache.kafka.common.utils.Crc32;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Crc32Test {
    @Test
    public void testUpdate() {
        byte[] bytes = "Any String you want".getBytes();
        int len = bytes.length;
        Crc32 crc1 = new Crc32();
        Crc32 crc2 = new Crc32();
        Crc32 crc3 = new Crc32();
        crc1.update(bytes, 0, len);
        for (int i = 0; i < len; ++i) {
            crc2.update(bytes[i]);
        }
        crc3.update(bytes, 0, len / 2);
        crc3.update(bytes, len / 2, len - len / 2);
        Assertions.assertEquals((long)crc1.getValue(), (long)crc2.getValue(), (String)"Crc values should be the same");
        Assertions.assertEquals((long)crc1.getValue(), (long)crc3.getValue(), (String)"Crc values should be the same");
    }

    @Test
    public void testValue() {
        byte[] bytes = "Some String".getBytes();
        Assertions.assertEquals((long)2021503672L, (long)Crc32.crc32((byte[])bytes));
    }
}

