/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.record.CompressionRatioEstimator;
import org.apache.kafka.common.record.CompressionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompressionRatioEstimatorTest {
    @Test
    public void testUpdateEstimation() {
        class EstimationsObservedRatios {
            float currentEstimation;
            float observedRatio;

            EstimationsObservedRatios(float currentEstimation, float observedRatio) {
                this.currentEstimation = currentEstimation;
                this.observedRatio = observedRatio;
            }
        }
        List<EstimationsObservedRatios> estimationsObservedRatios = Arrays.asList(new EstimationsObservedRatios(0.8f, 0.84f), new EstimationsObservedRatios(0.6f, 0.7f), new EstimationsObservedRatios(0.6f, 0.4f), new EstimationsObservedRatios(0.004f, 0.001f));
        for (EstimationsObservedRatios estimationsObservedRatio : estimationsObservedRatios) {
            String topic = "tp";
            CompressionRatioEstimator.setEstimation((String)topic, (CompressionType)CompressionType.ZSTD, (float)estimationsObservedRatio.currentEstimation);
            float updatedCompressionRatio = CompressionRatioEstimator.updateEstimation((String)topic, (CompressionType)CompressionType.ZSTD, (float)estimationsObservedRatio.observedRatio);
            Assertions.assertTrue((updatedCompressionRatio >= estimationsObservedRatio.observedRatio ? 1 : 0) != 0);
        }
    }
}

