/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourcePatternTest {
    @Test
    public void shouldThrowIfResourceTypeIsAny() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ResourcePattern(ResourceType.ANY, "name", PatternType.LITERAL));
    }

    @Test
    public void shouldThrowIfPatternTypeIsMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ResourcePattern(ResourceType.TOPIC, "name", PatternType.MATCH));
    }

    @Test
    public void shouldThrowIfPatternTypeIsAny() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ResourcePattern(ResourceType.TOPIC, "name", PatternType.ANY));
    }

    @Test
    public void shouldThrowIfResourceNameIsNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new ResourcePattern(ResourceType.TOPIC, null, PatternType.ANY));
    }
}

