/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class OffsetForLeaderEpochRequestData
implements ApiMessage {
    private int replicaId;
    private List<OffsetForLeaderTopic> topics;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema[] SCHEMAS;

    public OffsetForLeaderEpochRequestData(Readable readable, short version) {
        this.topics = new ArrayList<OffsetForLeaderTopic>();
        this.read(readable, version);
    }

    public OffsetForLeaderEpochRequestData(Struct struct, short version) {
        this.topics = new ArrayList<OffsetForLeaderTopic>();
        this.fromStruct(struct, version);
    }

    public OffsetForLeaderEpochRequestData() {
        this.replicaId = -2;
        this.topics = new ArrayList<OffsetForLeaderTopic>();
    }

    @Override
    public short apiKey() {
        return 23;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 3;
    }

    @Override
    public void read(Readable readable, short version) {
        this.replicaId = version >= 3 ? readable.readInt() : -2;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new OffsetForLeaderTopic(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        if (version >= 3) {
            writable.writeInt(this.replicaId);
        }
        writable.writeInt(this.topics.size());
        for (OffsetForLeaderTopic element : this.topics) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.replicaId = version >= 3 ? struct.getInt("replica_id") : -2;
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<OffsetForLeaderTopic>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new OffsetForLeaderTopic((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 3) {
            struct.set("replica_id", (Object)this.replicaId);
        }
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (OffsetForLeaderTopic element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        if (version >= 3) {
            size += 4;
        }
        size += 4;
        for (OffsetForLeaderTopic element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OffsetForLeaderEpochRequestData)) {
            return false;
        }
        OffsetForLeaderEpochRequestData other = (OffsetForLeaderEpochRequestData)obj;
        if (this.replicaId != other.replicaId) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.replicaId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "OffsetForLeaderEpochRequestData(replicaId=" + this.replicaId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int replicaId() {
        return this.replicaId;
    }

    public List<OffsetForLeaderTopic> topics() {
        return this.topics;
    }

    public OffsetForLeaderEpochRequestData setReplicaId(int v) {
        this.replicaId = v;
        return this;
    }

    public OffsetForLeaderEpochRequestData setTopics(List<OffsetForLeaderTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(OffsetForLeaderTopic.SCHEMA_0), "Each topic to get offsets for."));
        SCHEMA_2 = new Schema(new Field("topics", new ArrayOf(OffsetForLeaderTopic.SCHEMA_2), "Each topic to get offsets for."));
        SCHEMA_3 = new Schema(new Field("replica_id", Type.INT32, "The broker ID of the follower, of -1 if this request is from a consumer."), new Field("topics", new ArrayOf(OffsetForLeaderTopic.SCHEMA_2), "Each topic to get offsets for."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
    }

    public static class OffsetForLeaderPartition
    implements Message {
        private int partitionIndex;
        private int currentLeaderEpoch;
        private int leaderEpoch;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public OffsetForLeaderPartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public OffsetForLeaderPartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public OffsetForLeaderPartition() {
            this.partitionIndex = 0;
            this.currentLeaderEpoch = -1;
            this.leaderEpoch = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.currentLeaderEpoch = version >= 2 ? readable.readInt() : -1;
            this.leaderEpoch = readable.readInt();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            if (version >= 2) {
                writable.writeInt(this.currentLeaderEpoch);
            }
            writable.writeInt(this.leaderEpoch);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.currentLeaderEpoch = version >= 2 ? struct.getInt("current_leader_epoch") : -1;
            this.leaderEpoch = struct.getInt("leader_epoch");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            if (version >= 2) {
                struct.set("current_leader_epoch", (Object)this.currentLeaderEpoch);
            }
            struct.set("leader_epoch", (Object)this.leaderEpoch);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 4;
            if (version >= 2) {
                size += 4;
            }
            return size += 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetForLeaderPartition)) {
                return false;
            }
            OffsetForLeaderPartition other = (OffsetForLeaderPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.currentLeaderEpoch != other.currentLeaderEpoch) {
                return false;
            }
            return this.leaderEpoch == other.leaderEpoch;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.currentLeaderEpoch;
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        public String toString() {
            return "OffsetForLeaderPartition(partitionIndex=" + this.partitionIndex + ", currentLeaderEpoch=" + this.currentLeaderEpoch + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public int currentLeaderEpoch() {
            return this.currentLeaderEpoch;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public OffsetForLeaderPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public OffsetForLeaderPartition setCurrentLeaderEpoch(int v) {
            this.currentLeaderEpoch = v;
            return this;
        }

        public OffsetForLeaderPartition setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("leader_epoch", Type.INT32, "The epoch to look up an offset for."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("current_leader_epoch", Type.INT32, "An epoch used to fence consumers/replicas with old metadata.  If the epoch provided by the client is larger than the current epoch known to the broker, then the UNKNOWN_LEADER_EPOCH error code will be returned. If the provided epoch is smaller, then the FENCED_LEADER_EPOCH error code will be returned."), new Field("leader_epoch", Type.INT32, "The epoch to look up an offset for."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }

    public static class OffsetForLeaderTopic
    implements Message {
        private String name;
        private List<OffsetForLeaderPartition> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema[] SCHEMAS;

        public OffsetForLeaderTopic(Readable readable, short version) {
            this.partitions = new ArrayList<OffsetForLeaderPartition>();
            this.read(readable, version);
        }

        public OffsetForLeaderTopic(Struct struct, short version) {
            this.partitions = new ArrayList<OffsetForLeaderPartition>();
            this.fromStruct(struct, version);
        }

        public OffsetForLeaderTopic() {
            this.name = "";
            this.partitions = new ArrayList<OffsetForLeaderPartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 3;
        }

        @Override
        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new OffsetForLeaderPartition(readable, version));
                }
            }
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (OffsetForLeaderPartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<OffsetForLeaderPartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new OffsetForLeaderPartition((Struct)nestedObject, version));
            }
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (OffsetForLeaderPartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.name);
            size += 4;
            for (OffsetForLeaderPartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OffsetForLeaderTopic)) {
                return false;
            }
            OffsetForLeaderTopic other = (OffsetForLeaderTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "OffsetForLeaderTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<OffsetForLeaderPartition> partitions() {
            return this.partitions;
        }

        public OffsetForLeaderTopic setName(String v) {
            this.name = v;
            return this;
        }

        public OffsetForLeaderTopic setPartitions(List<OffsetForLeaderPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetForLeaderPartition.SCHEMA_0), "Each partition to get offsets for."));
            SCHEMA_3 = SCHEMA_2 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(OffsetForLeaderPartition.SCHEMA_2), "Each partition to get offsets for."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3};
        }
    }
}

