/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ControlledShutdownResponseData
implements ApiMessage {
    private short errorCode;
    private RemainingPartitionCollection remainingPartitions;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public ControlledShutdownResponseData(Readable readable, short version) {
        this.remainingPartitions = new RemainingPartitionCollection(0);
        this.read(readable, version);
    }

    public ControlledShutdownResponseData(Struct struct, short version) {
        this.remainingPartitions = new RemainingPartitionCollection(0);
        this.fromStruct(struct, version);
    }

    public ControlledShutdownResponseData() {
        this.errorCode = 0;
        this.remainingPartitions = new RemainingPartitionCollection(0);
    }

    @Override
    public short apiKey() {
        return 7;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.errorCode = readable.readShort();
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.remainingPartitions = null;
        } else {
            this.remainingPartitions.clear(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                this.remainingPartitions.add(new RemainingPartition(readable, version));
            }
        }
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeShort(this.errorCode);
        writable.writeInt(this.remainingPartitions.size());
        for (RemainingPartition element : this.remainingPartitions) {
            element.write(writable, version);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.errorCode = struct.getShort("error_code");
        Object[] nestedObjects = struct.getArray("remaining_partitions");
        this.remainingPartitions = new RemainingPartitionCollection(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.remainingPartitions.add(new RemainingPartition((Struct)nestedObject, version));
        }
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("error_code", (Object)this.errorCode);
        Struct[] nestedObjects = new Struct[this.remainingPartitions.size()];
        int i = 0;
        for (RemainingPartition element : this.remainingPartitions) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("remaining_partitions", (Object)nestedObjects);
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += 4;
        for (RemainingPartition element : this.remainingPartitions) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ControlledShutdownResponseData)) {
            return false;
        }
        ControlledShutdownResponseData other = (ControlledShutdownResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        return !(this.remainingPartitions == null ? other.remainingPartitions != null : !this.remainingPartitions.equals(other.remainingPartitions));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.remainingPartitions == null ? 0 : this.remainingPartitions.hashCode());
        return hashCode;
    }

    public String toString() {
        return "ControlledShutdownResponseData(errorCode=" + this.errorCode + ", remainingPartitions=" + MessageUtil.deepToString(this.remainingPartitions.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public RemainingPartitionCollection remainingPartitions() {
        return this.remainingPartitions;
    }

    public ControlledShutdownResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ControlledShutdownResponseData setRemainingPartitions(RemainingPartitionCollection v) {
        this.remainingPartitions = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The top-level error code."), new Field("remaining_partitions", new ArrayOf(RemainingPartition.SCHEMA_0), "The partitions that the broker still leads.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class RemainingPartitionCollection
    extends ImplicitLinkedHashMultiCollection<RemainingPartition> {
        public RemainingPartitionCollection() {
        }

        public RemainingPartitionCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public RemainingPartitionCollection(Iterator<RemainingPartition> iterator) {
            super(iterator);
        }

        public RemainingPartition find(String topicName, int partitionIndex) {
            RemainingPartition key = new RemainingPartition();
            key.setTopicName(topicName);
            key.setPartitionIndex(partitionIndex);
            return this.find(key);
        }

        public List<RemainingPartition> findAll(String topicName, int partitionIndex) {
            RemainingPartition key = new RemainingPartition();
            key.setTopicName(topicName);
            key.setPartitionIndex(partitionIndex);
            return this.findAll(key);
        }
    }

    public static class RemainingPartition
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String topicName;
        private int partitionIndex;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public RemainingPartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public RemainingPartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public RemainingPartition() {
            this.topicName = "";
            this.partitionIndex = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable readable, short version) {
            this.topicName = readable.readNullableString();
            this.partitionIndex = readable.readInt();
        }

        @Override
        public void write(Writable writable, short version) {
            writable.writeString(this.topicName);
            writable.writeInt(this.partitionIndex);
        }

        @Override
        public void fromStruct(Struct struct, short version) {
            this.topicName = struct.getString("topic_name");
            this.partitionIndex = struct.getInt("partition_index");
        }

        @Override
        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("topic_name", (Object)this.topicName);
            struct.set("partition_index", (Object)this.partitionIndex);
            return struct;
        }

        @Override
        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length(this.topicName);
            return size += 4;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RemainingPartition)) {
                return false;
            }
            RemainingPartition other = (RemainingPartition)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            return this.partitionIndex == other.partitionIndex;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        public String toString() {
            return "RemainingPartition(topicName='" + this.topicName + "', partitionIndex=" + this.partitionIndex + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        public RemainingPartition setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public RemainingPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_2 = SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The name of the topic."), new Field("partition_index", Type.INT32, "The index of the partition.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

