/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;

@InterfaceStability.Evolving
public class ElectPreferredLeadersResult {
    private final KafkaFutureImpl<Map<TopicPartition, ApiError>> electionFuture;
    private final Set<TopicPartition> partitions;

    ElectPreferredLeadersResult(KafkaFutureImpl<Map<TopicPartition, ApiError>> electionFuture, Set<TopicPartition> partitions) {
        this.electionFuture = electionFuture;
        this.partitions = partitions;
    }

    public KafkaFuture<Void> partitionResult(final TopicPartition partition) {
        final KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.electionFuture.whenComplete(new KafkaFuture.BiConsumer<Map<TopicPartition, ApiError>, Throwable>(){

            @Override
            public void accept(Map<TopicPartition, ApiError> topicPartitions, Throwable throwable) {
                if (throwable != null) {
                    result.completeExceptionally(throwable);
                } else if (!topicPartitions.containsKey(partition)) {
                    result.completeExceptionally(new UnknownTopicOrPartitionException("Preferred leader election for partition \"" + partition + "\" was not attempted"));
                } else if (ElectPreferredLeadersResult.this.partitions == null && topicPartitions.isEmpty()) {
                    result.completeExceptionally(Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
                } else {
                    ApiException exception = topicPartitions.get(partition).exception();
                    if (exception == null) {
                        result.complete(null);
                    } else {
                        result.completeExceptionally(exception);
                    }
                }
            }
        });
        return result;
    }

    public KafkaFuture<Set<TopicPartition>> partitions() {
        if (this.partitions != null) {
            return KafkaFutureImpl.completedFuture(this.partitions);
        }
        final KafkaFutureImpl<Set<TopicPartition>> result = new KafkaFutureImpl<Set<TopicPartition>>();
        this.electionFuture.whenComplete(new KafkaFuture.BiConsumer<Map<TopicPartition, ApiError>, Throwable>(){

            @Override
            public void accept(Map<TopicPartition, ApiError> topicPartitions, Throwable throwable) {
                if (throwable != null) {
                    result.completeExceptionally(throwable);
                } else if (topicPartitions.isEmpty()) {
                    result.completeExceptionally(Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
                } else {
                    for (ApiError apiError : topicPartitions.values()) {
                        if (!apiError.isFailure()) continue;
                        result.completeExceptionally(apiError.exception());
                    }
                    result.complete(topicPartitions.keySet());
                }
            }
        });
        return result;
    }

    public KafkaFuture<Void> all() {
        final KafkaFutureImpl<Void> result = new KafkaFutureImpl<Void>();
        this.electionFuture.thenApply(new KafkaFuture.Function<Map<TopicPartition, ApiError>, Void>(){

            @Override
            public Void apply(Map<TopicPartition, ApiError> topicPartitions) {
                for (ApiError apiError : topicPartitions.values()) {
                    if (!apiError.isFailure()) continue;
                    result.completeExceptionally(apiError.exception());
                    return null;
                }
                result.complete(null);
                return null;
            }
        });
        return result;
    }
}

