/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class SimpleLegacyRecordTest {
    @Test(expected=InvalidRecordException.class)
    public void testCompressedIterationWithNullValue() throws Exception {
        ByteBuffer buffer = ByteBuffer.allocate(128);
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(buffer));
        AbstractLegacyRecordBatch.writeHeader((DataOutputStream)out, (long)0L, (int)22);
        LegacyRecord.write((DataOutputStream)out, (byte)1, (long)1L, (byte[])null, null, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        if (records.records().iterator().hasNext()) {
            Assert.fail((String)"Iteration should have caused invalid record error");
        }
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedIterationWithEmptyRecords() throws Exception {
        ByteBuffer emptyCompressedValue = ByteBuffer.allocate(64);
        OutputStream gzipOutput = CompressionType.GZIP.wrapForOutput(new ByteBufferOutputStream(emptyCompressedValue), (byte)1);
        gzipOutput.close();
        emptyCompressedValue.flip();
        ByteBuffer buffer = ByteBuffer.allocate(128);
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(buffer));
        AbstractLegacyRecordBatch.writeHeader((DataOutputStream)out, (long)0L, (int)(22 + emptyCompressedValue.remaining()));
        LegacyRecord.write((DataOutputStream)out, (byte)1, (long)1L, null, (byte[])Utils.toArray((ByteBuffer)emptyCompressedValue), (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        if (records.records().iterator().hasNext()) {
            Assert.fail((String)"Iteration should have caused invalid record error");
        }
    }

    @Test(expected=InvalidRecordException.class)
    public void testIsValidWithTooSmallBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        LegacyRecord record = new LegacyRecord(buffer);
        Assert.assertFalse((boolean)record.isValid());
        record.ensureValid();
    }

    @Test(expected=InvalidRecordException.class)
    public void testIsValidWithChecksumMismatch() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(2);
        LegacyRecord record = new LegacyRecord(buffer);
        Assert.assertFalse((boolean)record.isValid());
        record.ensureValid();
    }
}

