/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class DeleteAclsRequestData
implements ApiMessage {
    private List<DeleteAclsFilter> filters = new ArrayList<DeleteAclsFilter>();
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("filters", (Type)new ArrayOf((Type)DeleteAclsFilter.SCHEMA_0), "The filters to use when deleting ACLs.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("filters", (Type)new ArrayOf((Type)DeleteAclsFilter.SCHEMA_1), "The filters to use when deleting ACLs.")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public DeleteAclsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public DeleteAclsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public DeleteAclsRequestData() {
    }

    public short apiKey() {
        return 31;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.filters = null;
        } else {
            this.filters.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.filters.add(new DeleteAclsFilter(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.filters.size());
        for (DeleteAclsFilter element : this.filters) {
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("filters");
        this.filters = new ArrayList<DeleteAclsFilter>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.filters.add(new DeleteAclsFilter((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.filters.size()];
        int i = 0;
        for (DeleteAclsFilter element : this.filters) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("filters", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        for (DeleteAclsFilter element : this.filters) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteAclsRequestData)) {
            return false;
        }
        DeleteAclsRequestData other = (DeleteAclsRequestData)obj;
        return !(this.filters == null ? other.filters != null : !this.filters.equals(other.filters));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.filters == null ? 0 : this.filters.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DeleteAclsRequestData(filters=" + MessageUtil.deepToString(this.filters.iterator()) + ")";
    }

    public List<DeleteAclsFilter> filters() {
        return this.filters;
    }

    public DeleteAclsRequestData setFilters(List<DeleteAclsFilter> v) {
        this.filters = v;
        return this;
    }

    public static class DeleteAclsFilter
    implements Message {
        private byte resourceTypeFilter;
        private String resourceNameFilter;
        private byte patternTypeFilter;
        private String principalFilter;
        private String hostFilter;
        private byte operation;
        private byte permissionType;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("resource_type_filter", (Type)Type.INT8, "The resource type."), new Field("resource_name_filter", (Type)Type.NULLABLE_STRING, "The resource name."), new Field("principal_filter", (Type)Type.NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", (Type)Type.NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", (Type)Type.INT8, "The ACL operation."), new Field("permission_type", (Type)Type.INT8, "The permission type.")});
        public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("resource_type_filter", (Type)Type.INT8, "The resource type."), new Field("resource_name_filter", (Type)Type.NULLABLE_STRING, "The resource name."), new Field("pattern_type_filter", (Type)Type.INT8, "The pattern type."), new Field("principal_filter", (Type)Type.NULLABLE_STRING, "The principal filter, or null to accept all principals."), new Field("host_filter", (Type)Type.NULLABLE_STRING, "The host filter, or null to accept all hosts."), new Field("operation", (Type)Type.INT8, "The ACL operation."), new Field("permission_type", (Type)Type.INT8, "The permission type.")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

        public DeleteAclsFilter(Readable readable, short version) {
            this.read(readable, version);
        }

        public DeleteAclsFilter(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public DeleteAclsFilter() {
            this.resourceTypeFilter = 0;
            this.resourceNameFilter = "";
            this.patternTypeFilter = (byte)3;
            this.principalFilter = "";
            this.hostFilter = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.resourceTypeFilter = readable.readByte();
            this.resourceNameFilter = readable.readNullableString();
            this.patternTypeFilter = version >= 1 ? readable.readByte() : (byte)3;
            this.principalFilter = readable.readNullableString();
            this.hostFilter = readable.readNullableString();
            this.operation = readable.readByte();
            this.permissionType = readable.readByte();
        }

        public void write(Writable writable, short version) {
            writable.writeByte(this.resourceTypeFilter);
            writable.writeNullableString(this.resourceNameFilter);
            if (version >= 1) {
                writable.writeByte(this.patternTypeFilter);
            }
            writable.writeNullableString(this.principalFilter);
            writable.writeNullableString(this.hostFilter);
            writable.writeByte(this.operation);
            writable.writeByte(this.permissionType);
        }

        public void fromStruct(Struct struct, short version) {
            this.resourceTypeFilter = struct.getByte("resource_type_filter");
            this.resourceNameFilter = struct.getString("resource_name_filter");
            this.patternTypeFilter = version >= 1 ? struct.getByte("pattern_type_filter") : (byte)3;
            this.principalFilter = struct.getString("principal_filter");
            this.hostFilter = struct.getString("host_filter");
            this.operation = struct.getByte("operation");
            this.permissionType = struct.getByte("permission_type");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("resource_type_filter", (Object)this.resourceTypeFilter);
            struct.set("resource_name_filter", (Object)this.resourceNameFilter);
            if (version >= 1) {
                struct.set("pattern_type_filter", (Object)this.patternTypeFilter);
            }
            struct.set("principal_filter", (Object)this.principalFilter);
            struct.set("host_filter", (Object)this.hostFilter);
            struct.set("operation", (Object)this.operation);
            struct.set("permission_type", (Object)this.permissionType);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            ++size;
            size += 2;
            if (this.resourceNameFilter != null) {
                size += MessageUtil.serializedUtf8Length((CharSequence)this.resourceNameFilter);
            }
            if (version >= 1) {
                ++size;
            } else if (this.patternTypeFilter != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternTypeFilter at version " + version);
            }
            size += 2;
            if (this.principalFilter != null) {
                size += MessageUtil.serializedUtf8Length((CharSequence)this.principalFilter);
            }
            size += 2;
            if (this.hostFilter != null) {
                size += MessageUtil.serializedUtf8Length((CharSequence)this.hostFilter);
            }
            ++size;
            return ++size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteAclsFilter)) {
                return false;
            }
            DeleteAclsFilter other = (DeleteAclsFilter)obj;
            if (this.resourceTypeFilter != other.resourceTypeFilter) {
                return false;
            }
            if (this.resourceNameFilter == null ? other.resourceNameFilter != null : !this.resourceNameFilter.equals(other.resourceNameFilter)) {
                return false;
            }
            if (this.patternTypeFilter != other.patternTypeFilter) {
                return false;
            }
            if (this.principalFilter == null ? other.principalFilter != null : !this.principalFilter.equals(other.principalFilter)) {
                return false;
            }
            if (this.hostFilter == null ? other.hostFilter != null : !this.hostFilter.equals(other.hostFilter)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            return this.permissionType == other.permissionType;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceTypeFilter;
            hashCode = 31 * hashCode + (this.resourceNameFilter == null ? 0 : this.resourceNameFilter.hashCode());
            hashCode = 31 * hashCode + this.patternTypeFilter;
            hashCode = 31 * hashCode + (this.principalFilter == null ? 0 : this.principalFilter.hashCode());
            hashCode = 31 * hashCode + (this.hostFilter == null ? 0 : this.hostFilter.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        public String toString() {
            return "DeleteAclsFilter(resourceTypeFilter=" + this.resourceTypeFilter + ", resourceNameFilter='" + this.resourceNameFilter + "', patternTypeFilter=" + this.patternTypeFilter + ", principalFilter='" + this.principalFilter + "', hostFilter='" + this.hostFilter + "', operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public byte resourceTypeFilter() {
            return this.resourceTypeFilter;
        }

        public String resourceNameFilter() {
            return this.resourceNameFilter;
        }

        public byte patternTypeFilter() {
            return this.patternTypeFilter;
        }

        public String principalFilter() {
            return this.principalFilter;
        }

        public String hostFilter() {
            return this.hostFilter;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        public DeleteAclsFilter setResourceTypeFilter(byte v) {
            this.resourceTypeFilter = v;
            return this;
        }

        public DeleteAclsFilter setResourceNameFilter(String v) {
            this.resourceNameFilter = v;
            return this;
        }

        public DeleteAclsFilter setPatternTypeFilter(byte v) {
            this.patternTypeFilter = v;
            return this;
        }

        public DeleteAclsFilter setPrincipalFilter(String v) {
            this.principalFilter = v;
            return this;
        }

        public DeleteAclsFilter setHostFilter(String v) {
            this.hostFilter = v;
            return this;
        }

        public DeleteAclsFilter setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public DeleteAclsFilter setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }
    }
}

