/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.junit.Assert;
import org.junit.Test;

public class AdminMetadataManagerTest {
    private final MockTime time = new MockTime();
    private final LogContext logContext = new LogContext();
    private final long refreshBackoffMs = 100L;
    private final long metadataExpireMs = 60000L;
    private final AdminMetadataManager mgr = new AdminMetadataManager(this.logContext, 100L, 60000L);

    @Test
    public void testMetadataReady() {
        Assert.assertFalse((boolean)this.mgr.isReady());
        Assert.assertEquals((long)0L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.mgr.update(Cluster.bootstrap(Collections.singletonList(new InetSocketAddress("localhost", 9999))), this.time.milliseconds());
        Assert.assertFalse((boolean)this.mgr.isReady());
        Assert.assertEquals((long)0L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.mgr.update(AdminMetadataManagerTest.mockCluster(), this.time.milliseconds());
        Assert.assertTrue((boolean)this.mgr.isReady());
        Assert.assertEquals((long)60000L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.time.sleep(60000L);
        Assert.assertEquals((long)0L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
    }

    @Test
    public void testMetadataRefreshBackoff() {
        this.mgr.transitionToUpdatePending(this.time.milliseconds());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.mgr.updateFailed((Throwable)new RuntimeException());
        Assert.assertEquals((long)100L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.mgr.requestUpdate();
        Assert.assertEquals((long)100L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        this.time.sleep(100L);
        Assert.assertEquals((long)0L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
    }

    @Test
    public void testAuthenticationFailure() {
        this.mgr.transitionToUpdatePending(this.time.milliseconds());
        this.mgr.updateFailed((Throwable)new AuthenticationException("Authentication failed"));
        Assert.assertEquals((long)100L, (long)this.mgr.metadataFetchDelayMs(this.time.milliseconds()));
        try {
            this.mgr.isReady();
            Assert.fail((String)"Expected AuthenticationException to be thrown");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        this.mgr.update(AdminMetadataManagerTest.mockCluster(), this.time.milliseconds());
        Assert.assertTrue((boolean)this.mgr.isReady());
    }

    private static Cluster mockCluster() {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        nodes.put(0, new Node(0, "localhost", 8121));
        nodes.put(1, new Node(1, "localhost", 8122));
        nodes.put(2, new Node(2, "localhost", 8123));
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
    }
}

