/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataCache;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.test.MockClusterResourceListener;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MetadataTest {
    private long refreshBackoffMs = 100L;
    private long metadataExpireMs = 1000L;
    private Metadata metadata = new Metadata(this.refreshBackoffMs, this.metadataExpireMs, new LogContext(), new ClusterResourceListeners());

    private static MetadataResponse emptyMetadataResponse() {
        return MetadataResponse.prepareResponse(Collections.emptyList(), null, (int)-1, Collections.emptyList());
    }

    @Test(expected=IllegalStateException.class)
    public void testMetadataUpdateAfterClose() {
        this.metadata.close();
        this.metadata.update(MetadataTest.emptyMetadataResponse(), 1000L);
    }

    private static void checkTimeToNextUpdate(long refreshBackoffMs, long metadataExpireMs) {
        long now = 10000L;
        if (metadataExpireMs > now || refreshBackoffMs > now) {
            throw new IllegalArgumentException("metadataExpireMs and refreshBackoffMs must be smaller than 'now'");
        }
        long largerOfBackoffAndExpire = Math.max(refreshBackoffMs, metadataExpireMs);
        Metadata metadata = new Metadata(refreshBackoffMs, metadataExpireMs, new LogContext(), new ClusterResourceListeners());
        Assert.assertEquals((long)0L, (long)metadata.timeToNextUpdate(now));
        metadata.update(MetadataTest.emptyMetadataResponse(), now);
        Assert.assertEquals((long)largerOfBackoffAndExpire, (long)metadata.timeToNextUpdate(now));
        metadata.requestUpdate();
        Assert.assertEquals((long)refreshBackoffMs, (long)metadata.timeToNextUpdate(now));
        metadata.update(MetadataTest.emptyMetadataResponse(), now);
        Assert.assertEquals((long)largerOfBackoffAndExpire, (long)metadata.timeToNextUpdate(now));
        Assert.assertEquals((long)0L, (long)metadata.timeToNextUpdate(now += largerOfBackoffAndExpire));
        Assert.assertEquals((long)0L, (long)metadata.timeToNextUpdate(now + 1L));
    }

    @Test
    public void testTimeToNextUpdate() {
        MetadataTest.checkTimeToNextUpdate(100L, 1000L);
        MetadataTest.checkTimeToNextUpdate(1000L, 100L);
        MetadataTest.checkTimeToNextUpdate(0L, 0L);
        MetadataTest.checkTimeToNextUpdate(0L, 100L);
        MetadataTest.checkTimeToNextUpdate(100L, 0L);
    }

    @Test
    public void testTimeToNextUpdate_RetryBackoff() {
        long now = 10000L;
        this.metadata.failedUpdate(now, null);
        Assert.assertEquals((long)this.refreshBackoffMs, (long)this.metadata.timeToNextUpdate(now));
        this.metadata.requestUpdate();
        Assert.assertEquals((long)this.refreshBackoffMs, (long)this.metadata.timeToNextUpdate(now));
        Assert.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now += this.refreshBackoffMs));
        Assert.assertEquals((long)0L, (long)this.metadata.timeToNextUpdate(now + 1L));
    }

    @Test
    public void testFailedUpdate() {
        long time = 100L;
        this.metadata.update(MetadataTest.emptyMetadataResponse(), time);
        Assert.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1000L));
        this.metadata.failedUpdate(1100L, null);
        Assert.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1100L));
        Assert.assertEquals((long)100L, (long)this.metadata.lastSuccessfulUpdate());
        this.metadata.update(MetadataTest.emptyMetadataResponse(), time);
        Assert.assertEquals((long)100L, (long)this.metadata.timeToNextUpdate(1000L));
    }

    @Test
    public void testClusterListenerGetsNotifiedOfUpdate() {
        long time = 0L;
        MockClusterResourceListener mockClusterListener = new MockClusterResourceListener();
        ClusterResourceListeners listeners = new ClusterResourceListeners();
        listeners.maybeAdd((Object)mockClusterListener);
        this.metadata = new Metadata(this.refreshBackoffMs, this.metadataExpireMs, new LogContext(), listeners);
        String hostName = "www.example.com";
        this.metadata.bootstrap(Collections.singletonList(new InetSocketAddress(hostName, 9002)), time);
        Assert.assertFalse((String)"ClusterResourceListener should not called when metadata is updated with bootstrap Cluster", (boolean)MockClusterResourceListener.IS_ON_UPDATE_CALLED.get());
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic", 1);
        partitionCounts.put("topic1", 1);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, partitionCounts);
        this.metadata.update(metadataResponse, 100L);
        Assert.assertEquals((String)"MockClusterResourceListener did not get cluster metadata correctly", (Object)"dummy", (Object)mockClusterListener.clusterResource().clusterId());
        Assert.assertTrue((String)"MockClusterResourceListener should be called when metadata is updated with non-bootstrap Cluster", (boolean)MockClusterResourceListener.IS_ON_UPDATE_CALLED.get());
    }

    @Test
    public void testRequestUpdate() {
        Assert.assertFalse((boolean)this.metadata.updateRequested());
        int[] epochs = new int[]{42, 42, 41, 41, 42, 43, 43, 42, 41, 44};
        boolean[] updateResult = new boolean[]{true, false, false, false, false, true, false, false, false, true};
        TopicPartition tp = new TopicPartition("topic", 0);
        for (int i = 0; i < epochs.length; ++i) {
            this.metadata.updateLastSeenEpochIfNewer(tp, epochs[i]);
            if (updateResult[i]) {
                Assert.assertTrue((String)("Expected metadata update to be requested [" + i + "]"), (boolean)this.metadata.updateRequested());
            } else {
                Assert.assertFalse((String)("Did not expect metadata update to be requested [" + i + "]"), (boolean)this.metadata.updateRequested());
            }
            this.metadata.update(MetadataTest.emptyMetadataResponse(), 0L);
            Assert.assertFalse((boolean)this.metadata.updateRequested());
        }
    }

    @Test
    public void testRejectOldMetadata() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 1);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        this.metadata.update(MetadataTest.emptyMetadataResponse(), 0L);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 100);
        this.metadata.update(metadataResponse, 10L);
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 99, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, leader, leaderEpoch, replicas, Collections.emptyList(), offlineReplicas));
        this.metadata.update(metadataResponse, 20L);
        Assert.assertEquals((long)this.metadata.fetch().partition(tp).inSyncReplicas().length, (long)1L);
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 100, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, leader, leaderEpoch, replicas, Collections.emptyList(), offlineReplicas));
        this.metadata.update(metadataResponse, 20L);
        Assert.assertEquals((long)this.metadata.fetch().partition(tp).inSyncReplicas().length, (long)0L);
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.emptyMap());
        this.metadata.update(metadataResponse, 20L);
        Assert.assertNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 99);
        this.metadata.update(metadataResponse, 10L);
        Assert.assertNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
    }

    @Test
    public void testMaybeRequestUpdate() {
        TopicPartition tp = new TopicPartition("topic-1", 0);
        this.metadata.update(MetadataTest.emptyMetadataResponse(), 0L);
        Assert.assertTrue((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 1));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)1L);
        this.metadata.update(MetadataTest.emptyMetadataResponse(), 1L);
        Assert.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 1));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)1L);
        this.metadata.update(MetadataTest.emptyMetadataResponse(), 2L);
        Assert.assertFalse((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 0));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)1L);
        this.metadata.update(MetadataTest.emptyMetadataResponse(), 3L);
        Assert.assertTrue((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 2));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)2L);
    }

    @Test
    public void testOutOfBandEpochUpdate() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 5);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        this.metadata.update(MetadataTest.emptyMetadataResponse(), 0L);
        Assert.assertTrue((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 99));
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 100);
        this.metadata.update(metadataResponse, 10L);
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)100L);
        Assert.assertTrue((boolean)this.metadata.updateLastSeenEpochIfNewer(tp, 101));
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)this.metadata.fetch().partitionCountForTopic("topic-1").longValue(), (long)5L);
        Assert.assertFalse((boolean)this.metadata.partitionInfoIfCurrent(tp).isPresent());
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)101L);
        this.metadata.update(metadataResponse, 20L);
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)this.metadata.fetch().partitionCountForTopic("topic-1").longValue(), (long)5L);
        Assert.assertFalse((boolean)this.metadata.partitionInfoIfCurrent(tp).isPresent());
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)101L);
        metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), partitionCounts, _tp -> 101);
        this.metadata.update(metadataResponse, 30L);
        Assert.assertNotNull((Object)this.metadata.fetch().partition(tp));
        Assert.assertEquals((long)this.metadata.fetch().partitionCountForTopic("topic-1").longValue(), (long)5L);
        Assert.assertTrue((boolean)this.metadata.partitionInfoIfCurrent(tp).isPresent());
        Assert.assertEquals((long)((Integer)this.metadata.lastSeenLeaderEpoch(tp).get()).longValue(), (long)101L);
    }

    @Test
    public void testNoEpoch() {
        this.metadata.update(MetadataTest.emptyMetadataResponse(), 0L);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 1, Collections.emptyMap(), Collections.singletonMap("topic-1", 1));
        this.metadata.update(metadataResponse, 10L);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        Assert.assertFalse((boolean)this.metadata.lastSeenLeaderEpoch(tp).isPresent());
        Assert.assertTrue((boolean)this.metadata.partitionInfoIfCurrent(tp).isPresent());
        Assert.assertEquals((long)((MetadataCache.PartitionInfoAndEpoch)this.metadata.partitionInfoIfCurrent(tp).get()).partitionInfo().partition(), (long)0L);
        Assert.assertEquals((long)((MetadataCache.PartitionInfoAndEpoch)this.metadata.partitionInfoIfCurrent(tp).get()).partitionInfo().leader().id(), (long)0L);
    }

    @Test
    public void testClusterCopy() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        counts.put("topic1", 2);
        counts.put("topic2", 3);
        counts.put("__consumer_offsets", 3);
        errors.put("topic3", Errors.INVALID_TOPIC_EXCEPTION);
        errors.put("topic4", Errors.TOPIC_AUTHORIZATION_FAILED);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 4, errors, counts);
        this.metadata.update(metadataResponse, 0L);
        Cluster cluster = this.metadata.fetch();
        Assert.assertEquals((Object)cluster.clusterResource().clusterId(), (Object)"dummy");
        Assert.assertEquals((long)cluster.nodes().size(), (long)4L);
        Assert.assertEquals((Object)cluster.invalidTopics(), Collections.singleton("topic3"));
        Assert.assertEquals((Object)cluster.unauthorizedTopics(), Collections.singleton("topic4"));
        Assert.assertEquals((long)cluster.topics().size(), (long)3L);
        Assert.assertEquals((Object)cluster.internalTopics(), Collections.singleton("__consumer_offsets"));
        Assert.assertEquals((long)cluster.partitionsForTopic("topic1").size(), (long)2L);
        Assert.assertEquals((long)cluster.partitionsForTopic("topic2").size(), (long)3L);
        InetSocketAddress address = InetSocketAddress.createUnresolved("localhost", 0);
        Cluster fromMetadata = MetadataCache.bootstrap(Collections.singletonList(address)).cluster();
        Cluster fromCluster = Cluster.bootstrap(Collections.singletonList(address));
        Assert.assertEquals((Object)fromMetadata, (Object)fromCluster);
        Cluster fromMetadataEmpty = MetadataCache.empty().cluster();
        Cluster fromClusterEmpty = Cluster.empty();
        Assert.assertEquals((Object)fromMetadataEmpty, (Object)fromClusterEmpty);
    }

    @Test
    public void testRequestVersion() {
        MockTime time = new MockTime();
        this.metadata.requestUpdate();
        Metadata.MetadataRequestAndVersion versionAndBuilder = this.metadata.newMetadataRequestAndVersion();
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), time.milliseconds());
        Assert.assertFalse((boolean)this.metadata.updateRequested());
        this.metadata.requestUpdateForNewTopics();
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion();
        this.metadata.requestUpdateForNewTopics();
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), time.milliseconds());
        Assert.assertTrue((boolean)this.metadata.updateRequested());
        versionAndBuilder = this.metadata.newMetadataRequestAndVersion();
        this.metadata.update(versionAndBuilder.requestVersion, TestUtils.metadataUpdateWith(1, Collections.singletonMap("topic", 1)), time.milliseconds());
        Assert.assertFalse((boolean)this.metadata.updateRequested());
    }

    @Test
    public void testInvalidTopicError() {
        MockTime time = new MockTime();
        String invalidTopic = "topic dfsa";
        MetadataResponse invalidTopicResponse = TestUtils.metadataUpdateWith("clusterId", 1, Collections.singletonMap(invalidTopic, Errors.INVALID_TOPIC_EXCEPTION), Collections.emptyMap());
        this.metadata.update(invalidTopicResponse, time.milliseconds());
        InvalidTopicException e = (InvalidTopicException)Assert.assertThrows(InvalidTopicException.class, () -> this.metadata.maybeThrowException());
        Assert.assertEquals(Collections.singleton(invalidTopic), (Object)e.invalidTopics());
        Assert.assertNull((Object)((Object)this.metadata.getAndClearMetadataException()));
        this.metadata.update(invalidTopicResponse, time.milliseconds());
        this.metadata.update(MetadataTest.emptyMetadataResponse(), time.milliseconds());
        Assert.assertNull((Object)((Object)this.metadata.getAndClearMetadataException()));
    }

    @Test
    public void testTopicAuthorizationError() {
        MockTime time = new MockTime();
        String invalidTopic = "foo";
        MetadataResponse unauthorizedTopicResponse = TestUtils.metadataUpdateWith("clusterId", 1, Collections.singletonMap(invalidTopic, Errors.TOPIC_AUTHORIZATION_FAILED), Collections.emptyMap());
        this.metadata.update(unauthorizedTopicResponse, time.milliseconds());
        TopicAuthorizationException e = (TopicAuthorizationException)Assert.assertThrows(TopicAuthorizationException.class, () -> this.metadata.maybeThrowException());
        Assert.assertEquals(Collections.singleton(invalidTopic), (Object)e.unauthorizedTopics());
        Assert.assertNull((Object)((Object)this.metadata.getAndClearMetadataException()));
        this.metadata.update(unauthorizedTopicResponse, time.milliseconds());
        this.metadata.update(MetadataTest.emptyMetadataResponse(), time.milliseconds());
        Assert.assertNull((Object)((Object)this.metadata.getAndClearMetadataException()));
    }

    @Test
    public void testNodeIfOffline() {
        HashMap<String, Integer> partitionCounts = new HashMap<String, Integer>();
        partitionCounts.put("topic-1", 1);
        Node node0 = new Node(0, "localhost", 9092);
        Node node1 = new Node(1, "localhost", 9093);
        MetadataResponse metadataResponse = TestUtils.metadataUpdateWith("dummy", 2, Collections.emptyMap(), partitionCounts, _tp -> 99, (error, partition, leader, leaderEpoch, replicas, isr, offlineReplicas) -> new MetadataResponse.PartitionMetadata(error, partition, node0, leaderEpoch, Collections.singletonList(node0), Collections.emptyList(), Collections.singletonList(node1)));
        this.metadata.update(MetadataTest.emptyMetadataResponse(), 0L);
        this.metadata.update(metadataResponse, 10L);
        TopicPartition tp = new TopicPartition("topic-1", 0);
        TestUtils.assertOptional(this.metadata.fetch().nodeIfOnline(tp, 0), node -> Assert.assertEquals((long)node.id(), (long)0L));
        Assert.assertFalse((boolean)this.metadata.fetch().nodeIfOnline(tp, 1).isPresent());
        Assert.assertEquals((long)this.metadata.fetch().nodeById(0).id(), (long)0L);
        Assert.assertEquals((long)this.metadata.fetch().nodeById(1).id(), (long)1L);
    }
}

