/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.Arrays;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Bytes;

public class ExpireDelegationTokenRequestData
implements ApiMessage {
    private byte[] hmac;
    private long expiryTimePeriodMs;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public ExpireDelegationTokenRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public ExpireDelegationTokenRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public ExpireDelegationTokenRequestData() {
        this.hmac = Bytes.EMPTY;
        this.expiryTimePeriodMs = 0L;
    }

    public short apiKey() {
        return 40;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        this.hmac = readable.readNullableBytes();
        this.expiryTimePeriodMs = readable.readLong();
    }

    public void write(Writable writable, short version) {
        writable.writeBytes(this.hmac);
        writable.writeLong(this.expiryTimePeriodMs);
    }

    public void fromStruct(Struct struct, short version) {
        this.hmac = struct.getByteArray("hmac");
        this.expiryTimePeriodMs = struct.getLong("expiry_time_period_ms");
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.setByteArray("hmac", this.hmac);
        struct.set("expiry_time_period_ms", (Object)this.expiryTimePeriodMs);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        size += this.hmac.length;
        return size += 8;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExpireDelegationTokenRequestData)) {
            return false;
        }
        ExpireDelegationTokenRequestData other = (ExpireDelegationTokenRequestData)obj;
        if (!Arrays.equals(this.hmac, other.hmac)) {
            return false;
        }
        return this.expiryTimePeriodMs == other.expiryTimePeriodMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + Arrays.hashCode(this.hmac);
        hashCode = 31 * hashCode + ((int)(this.expiryTimePeriodMs >> 32) ^ (int)this.expiryTimePeriodMs);
        return hashCode;
    }

    public String toString() {
        return "ExpireDelegationTokenRequestData(hmac=" + Arrays.toString(this.hmac) + ", expiryTimePeriodMs=" + this.expiryTimePeriodMs + ")";
    }

    public byte[] hmac() {
        return this.hmac;
    }

    public long expiryTimePeriodMs() {
        return this.expiryTimePeriodMs;
    }

    public ExpireDelegationTokenRequestData setHmac(byte[] v) {
        this.hmac = v;
        return this;
    }

    public ExpireDelegationTokenRequestData setExpiryTimePeriodMs(long v) {
        this.expiryTimePeriodMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("hmac", (Type)Type.BYTES, "The HMAC of the delegation token to be expired."), new Field("expiry_time_period_ms", (Type)Type.INT64, "The expiry time period in milliseconds.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }
}

