/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.acl;

import org.apache.kafka.common.acl.AclPermissionType;
import org.junit.Assert;
import org.junit.Test;

public class AclPermissionTypeTest {
    private static final AclPermissionTypeTestInfo[] INFOS = new AclPermissionTypeTestInfo[]{new AclPermissionTypeTestInfo(AclPermissionType.UNKNOWN, 0, "unknown", true), new AclPermissionTypeTestInfo(AclPermissionType.ANY, 1, "any", false), new AclPermissionTypeTestInfo(AclPermissionType.DENY, 2, "deny", false), new AclPermissionTypeTestInfo(AclPermissionType.ALLOW, 3, "allow", false)};

    @Test
    public void testIsUnknown() throws Exception {
        for (AclPermissionTypeTestInfo info : INFOS) {
            Assert.assertEquals((String)(info.ty + " was supposed to have unknown == " + info.unknown), (Object)info.unknown, (Object)info.ty.isUnknown());
        }
    }

    @Test
    public void testCode() throws Exception {
        Assert.assertEquals((long)AclPermissionType.values().length, (long)INFOS.length);
        for (AclPermissionTypeTestInfo info : INFOS) {
            Assert.assertEquals((String)(info.ty + " was supposed to have code == " + info.code), (long)info.code, (long)info.ty.code());
            Assert.assertEquals((String)("AclPermissionType.fromCode(" + info.code + ") was supposed to be " + info.ty), (Object)info.ty, (Object)AclPermissionType.fromCode((byte)((byte)info.code)));
        }
        Assert.assertEquals((Object)AclPermissionType.UNKNOWN, (Object)AclPermissionType.fromCode((byte)120));
    }

    @Test
    public void testName() throws Exception {
        for (AclPermissionTypeTestInfo info : INFOS) {
            Assert.assertEquals((String)("AclPermissionType.fromString(" + info.name + ") was supposed to be " + info.ty), (Object)info.ty, (Object)AclPermissionType.fromString((String)info.name));
        }
        Assert.assertEquals((Object)AclPermissionType.UNKNOWN, (Object)AclPermissionType.fromString((String)"something"));
    }

    @Test
    public void testExhaustive() throws Exception {
        Assert.assertEquals((long)INFOS.length, (long)AclPermissionType.values().length);
        for (int i = 0; i < INFOS.length; ++i) {
            Assert.assertEquals((Object)INFOS[i].ty, (Object)AclPermissionType.values()[i]);
        }
    }

    private static class AclPermissionTypeTestInfo {
        private final AclPermissionType ty;
        private final int code;
        private final String name;
        private final boolean unknown;

        AclPermissionTypeTestInfo(AclPermissionType ty, int code, String name, boolean unknown) {
            this.ty = ty;
            this.code = code;
            this.name = name;
            this.unknown = unknown;
        }
    }
}

