/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.utils.Time;

public class MockTime
implements Time {
    private final CopyOnWriteArrayList<MockTimeListener> listeners = new CopyOnWriteArrayList();
    private final long autoTickMs;
    private final AtomicLong timeMs;
    private final AtomicLong highResTimeNs;

    public MockTime() {
        this(0L);
    }

    public MockTime(long autoTickMs) {
        this(autoTickMs, System.currentTimeMillis(), System.nanoTime());
    }

    public MockTime(long autoTickMs, long currentTimeMs, long currentHighResTimeNs) {
        this.timeMs = new AtomicLong(currentTimeMs);
        this.highResTimeNs = new AtomicLong(currentHighResTimeNs);
        this.autoTickMs = autoTickMs;
    }

    public void addListener(MockTimeListener listener) {
        this.listeners.add(listener);
    }

    public long milliseconds() {
        this.maybeSleep(this.autoTickMs);
        return this.timeMs.get();
    }

    public long nanoseconds() {
        this.maybeSleep(this.autoTickMs);
        return this.highResTimeNs.get();
    }

    private void maybeSleep(long ms) {
        if (ms != 0L) {
            this.sleep(ms);
        }
    }

    public void sleep(long ms) {
        this.timeMs.addAndGet(ms);
        this.highResTimeNs.addAndGet(TimeUnit.MILLISECONDS.toNanos(ms));
        this.tick();
    }

    public void setCurrentTimeMs(long newMs) {
        long oldMs = this.timeMs.getAndSet(newMs);
        if (oldMs > newMs) {
            throw new IllegalArgumentException("Setting the time to " + newMs + " while current time " + oldMs + " is newer; this is not allowed");
        }
        this.highResTimeNs.set(TimeUnit.MILLISECONDS.toNanos(newMs));
        this.tick();
    }

    private void tick() {
        for (MockTimeListener listener : this.listeners) {
            listener.tick();
        }
    }

    static interface MockTimeListener {
        public void tick();
    }
}

