/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class OAuthBearerLoginModuleTest {
    public static final SaslExtensions RAISE_UNSUPPORTED_CB_EXCEPTION_FLAG = null;

    @Test
    public void login1Commit1Login2Commit2Logout1Login3Commit3Logout2() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        SaslExtensions[] extensions = new SaslExtensions[]{(SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, extensions);
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule2 = new OAuthBearerLoginModule();
        loginModule2.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule3 = new OAuthBearerLoginModule();
        loginModule3.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule1.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule1.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.login();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.commit();
        Assert.assertEquals((long)2L, (long)privateCredentials.size());
        Assert.assertEquals((long)2L, (long)publicCredentials.size());
        Iterator<Object> iterator = privateCredentials.iterator();
        Iterator<Object> publicIterator = publicCredentials.iterator();
        Assert.assertNotSame((Object)tokens[2], (Object)iterator.next());
        Assert.assertNotSame((Object)tokens[2], (Object)iterator.next());
        Assert.assertNotSame((Object)extensions[2], (Object)publicIterator.next());
        Assert.assertNotSame((Object)extensions[2], (Object)publicIterator.next());
        loginModule1.logout();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[1], (Object)publicCredentials.iterator().next());
        loginModule3.login();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[1], (Object)publicCredentials.iterator().next());
        loginModule3.commit();
        Assert.assertEquals((long)2L, (long)privateCredentials.size());
        Assert.assertEquals((long)2L, (long)publicCredentials.size());
        iterator = privateCredentials.iterator();
        publicIterator = publicCredentials.iterator();
        Assert.assertNotSame((Object)tokens[0], (Object)iterator.next());
        Assert.assertNotSame((Object)tokens[0], (Object)iterator.next());
        Assert.assertNotSame((Object)extensions[0], (Object)publicIterator.next());
        Assert.assertNotSame((Object)extensions[0], (Object)publicIterator.next());
        loginModule2.logout();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[2], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[2], (Object)publicCredentials.iterator().next());
        Mockito.verifyZeroInteractions((Object[])tokens);
        Mockito.verifyZeroInteractions((Object[])extensions);
    }

    @Test
    public void login1Commit1Logout1Login2Commit2Logout2() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        SaslExtensions[] extensions = new SaslExtensions[]{(SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, extensions);
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule2 = new OAuthBearerLoginModule();
        loginModule2.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule1.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule1.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule1.logout();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule2.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule2.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[1], (Object)publicCredentials.iterator().next());
        loginModule2.logout();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        Mockito.verifyZeroInteractions((Object[])tokens);
        Mockito.verifyZeroInteractions((Object[])extensions);
    }

    @Test
    public void loginAbortLoginCommitLogout() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        SaslExtensions[] extensions = new SaslExtensions[]{(SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, extensions);
        OAuthBearerLoginModule loginModule = new OAuthBearerLoginModule();
        loginModule.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule.abort();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[1], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[1], (Object)publicCredentials.iterator().next());
        loginModule.logout();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        Mockito.verifyZeroInteractions((Object[])tokens);
        Mockito.verifyZeroInteractions((Object[])extensions);
    }

    @Test
    public void login1Commit1Login2Abort2Login3Commit3Logout3() throws LoginException {
        Subject subject = new Subject();
        Set<Object> privateCredentials = subject.getPrivateCredentials();
        Set<Object> publicCredentials = subject.getPublicCredentials();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        SaslExtensions[] extensions = new SaslExtensions[]{(SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class), (SaslExtensions)Mockito.mock(SaslExtensions.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, extensions);
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule2 = new OAuthBearerLoginModule();
        loginModule2.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        OAuthBearerLoginModule loginModule3 = new OAuthBearerLoginModule();
        loginModule3.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule1.login();
        Assert.assertEquals((long)0L, (long)privateCredentials.size());
        Assert.assertEquals((long)0L, (long)publicCredentials.size());
        loginModule1.commit();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.login();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assert.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.abort();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.login();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[0], (Object)privateCredentials.iterator().next());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)extensions[0], (Object)publicCredentials.iterator().next());
        loginModule2.commit();
        Assert.assertEquals((long)2L, (long)privateCredentials.size());
        Iterator<Object> iterator = privateCredentials.iterator();
        Assert.assertNotSame((Object)tokens[1], (Object)iterator.next());
        Assert.assertNotSame((Object)tokens[1], (Object)iterator.next());
        Assert.assertEquals((long)2L, (long)publicCredentials.size());
        Iterator<Object> publicIterator = publicCredentials.iterator();
        Assert.assertNotSame((Object)extensions[1], (Object)publicIterator.next());
        Assert.assertNotSame((Object)extensions[1], (Object)publicIterator.next());
        loginModule1.logout();
        Assert.assertEquals((long)1L, (long)privateCredentials.size());
        Assert.assertSame((Object)tokens[2], (Object)privateCredentials.iterator().next());
        Assert.assertEquals((long)1L, (long)publicCredentials.size());
        Assert.assertSame((Object)extensions[2], (Object)publicCredentials.iterator().next());
        Mockito.verifyZeroInteractions((Object[])tokens);
        Mockito.verifyZeroInteractions((Object[])extensions);
    }

    @Test
    public void commitDoesNotThrowOnUnsupportedExtensionsCallback() throws LoginException {
        Subject subject = new Subject();
        OAuthBearerToken[] tokens = new OAuthBearerToken[]{(OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class), (OAuthBearerToken)Mockito.mock(OAuthBearerToken.class)};
        TestCallbackHandler testTokenCallbackHandler = new TestCallbackHandler(tokens, new SaslExtensions[]{RAISE_UNSUPPORTED_CB_EXCEPTION_FLAG});
        OAuthBearerLoginModule loginModule1 = new OAuthBearerLoginModule();
        loginModule1.initialize(subject, (CallbackHandler)((Object)testTokenCallbackHandler), Collections.emptyMap(), Collections.emptyMap());
        loginModule1.login();
        loginModule1.commit();
        SaslExtensions extensions = subject.getPublicCredentials(SaslExtensions.class).iterator().next();
        Assert.assertNotNull((Object)extensions);
        Assert.assertTrue((boolean)extensions.map().isEmpty());
        Mockito.verifyZeroInteractions((Object[])tokens);
    }

    private static class TestCallbackHandler
    implements AuthenticateCallbackHandler {
        private final OAuthBearerToken[] tokens;
        private int index = 0;
        private int extensionsIndex = 0;
        private final SaslExtensions[] extensions;

        public TestCallbackHandler(OAuthBearerToken[] tokens, SaslExtensions[] extensions) {
            this.tokens = Objects.requireNonNull(tokens);
            this.extensions = extensions;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof OAuthBearerTokenCallback) {
                    try {
                        this.handleCallback((OAuthBearerTokenCallback)callback);
                        continue;
                    }
                    catch (KafkaException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
                if (callback instanceof SaslExtensionsCallback) {
                    try {
                        this.handleExtensionsCallback((SaslExtensionsCallback)callback);
                        continue;
                    }
                    catch (KafkaException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
                throw new UnsupportedCallbackException(callback);
            }
        }

        public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        }

        public void close() {
        }

        private void handleCallback(OAuthBearerTokenCallback callback) throws IOException {
            if (callback.token() != null) {
                throw new IllegalArgumentException("Callback had a token already");
            }
            if (this.tokens.length <= this.index) {
                throw new IOException("no more tokens");
            }
            callback.token(this.tokens[this.index++]);
        }

        private void handleExtensionsCallback(SaslExtensionsCallback callback) throws IOException, UnsupportedCallbackException {
            SaslExtensions extension;
            if (this.extensions.length > this.extensionsIndex) {
                if ((extension = this.extensions[this.extensionsIndex++]) == RAISE_UNSUPPORTED_CB_EXCEPTION_FLAG) {
                    throw new UnsupportedCallbackException((Callback)callback);
                }
            } else {
                throw new IOException("no more extensions");
            }
            callback.extensions(extension);
        }
    }
}

