/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.Heartbeat;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;

public class HeartbeatTest {
    private int sessionTimeoutMs = 300;
    private int heartbeatIntervalMs = 100;
    private int maxPollIntervalMs = 900;
    private long retryBackoffMs = 10L;
    private MockTime time = new MockTime();
    private Heartbeat heartbeat = new Heartbeat((Time)this.time, this.sessionTimeoutMs, this.heartbeatIntervalMs, this.maxPollIntervalMs, this.retryBackoffMs);

    @Test
    public void testShouldHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep((long)((double)this.heartbeatIntervalMs * 1.1));
        Assert.assertTrue((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testShouldNotHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(this.heartbeatIntervalMs / 2);
        Assert.assertFalse((boolean)this.heartbeat.shouldHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testTimeToNextHeartbeat() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        Assert.assertEquals((long)this.heartbeatIntervalMs, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        this.time.sleep(this.heartbeatIntervalMs);
        Assert.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        this.time.sleep(this.heartbeatIntervalMs);
        Assert.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
    }

    @Test
    public void testSessionTimeoutExpired() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(this.sessionTimeoutMs + 5);
        Assert.assertTrue((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testResetSession() {
        this.heartbeat.sentHeartbeat(this.time.milliseconds());
        this.time.sleep(this.sessionTimeoutMs + 5);
        this.heartbeat.resetSessionTimeout();
        Assert.assertFalse((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(this.maxPollIntervalMs + 1);
        this.heartbeat.resetSessionTimeout();
        Assert.assertTrue((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testResetTimeouts() {
        this.time.sleep(this.maxPollIntervalMs);
        Assert.assertTrue((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
        Assert.assertEquals((long)0L, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        Assert.assertTrue((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
        this.heartbeat.resetTimeouts();
        Assert.assertFalse((boolean)this.heartbeat.sessionTimeoutExpired(this.time.milliseconds()));
        Assert.assertEquals((long)this.heartbeatIntervalMs, (long)this.heartbeat.timeToNextHeartbeat(this.time.milliseconds()));
        Assert.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }

    @Test
    public void testPollTimeout() {
        Assert.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(this.maxPollIntervalMs / 2);
        Assert.assertFalse((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
        this.time.sleep(this.maxPollIntervalMs / 2 + 1);
        Assert.assertTrue((boolean)this.heartbeat.pollTimeoutExpired(this.time.milliseconds()));
    }
}

