/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.runtime.RestartRequest;
import org.apache.kafka.connect.runtime.SessionKey;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.WorkerConfigTransformer;
import org.apache.kafka.connect.storage.ClusterConfigState;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.util.ConnectorTaskId;

public class MemoryConfigBackingStore
implements ConfigBackingStore {
    private final Map<String, ConnectorState> connectors = new HashMap<String, ConnectorState>();
    private ConfigBackingStore.UpdateListener updateListener;
    private WorkerConfigTransformer configTransformer;

    public MemoryConfigBackingStore() {
    }

    public MemoryConfigBackingStore(WorkerConfigTransformer configTransformer) {
        this.configTransformer = configTransformer;
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public synchronized void stop() {
    }

    @Override
    public synchronized ClusterConfigState snapshot() {
        HashMap<String, Integer> connectorTaskCounts = new HashMap<String, Integer>();
        HashMap<String, Map<String, String>> connectorConfigs = new HashMap<String, Map<String, String>>();
        HashMap<String, TargetState> connectorTargetStates = new HashMap<String, TargetState>();
        HashMap<ConnectorTaskId, Map<String, String>> taskConfigs = new HashMap<ConnectorTaskId, Map<String, String>>();
        for (Map.Entry<String, ConnectorState> connectorStateEntry : this.connectors.entrySet()) {
            String connector = connectorStateEntry.getKey();
            ConnectorState connectorState = connectorStateEntry.getValue();
            connectorTaskCounts.put(connector, connectorState.taskConfigs.size());
            connectorConfigs.put(connector, connectorState.connConfig);
            connectorTargetStates.put(connector, connectorState.targetState);
            taskConfigs.putAll(connectorState.taskConfigs);
        }
        return new ClusterConfigState(-1L, null, connectorTaskCounts, connectorConfigs, connectorTargetStates, taskConfigs, Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptySet(), this.configTransformer);
    }

    @Override
    public synchronized boolean contains(String connector) {
        return this.connectors.containsKey(connector);
    }

    @Override
    public synchronized void putConnectorConfig(String connector, Map<String, String> properties) {
        ConnectorState state = this.connectors.get(connector);
        if (state == null) {
            this.connectors.put(connector, new ConnectorState(properties));
        } else {
            state.connConfig = properties;
        }
        if (this.updateListener != null) {
            this.updateListener.onConnectorConfigUpdate(connector);
        }
    }

    @Override
    public synchronized void removeConnectorConfig(String connector) {
        ConnectorState state = this.connectors.remove(connector);
        if (this.updateListener != null && state != null) {
            this.updateListener.onConnectorConfigRemove(connector);
        }
    }

    @Override
    public synchronized void removeTaskConfigs(String connector) {
        ConnectorState state = this.connectors.get(connector);
        if (state == null) {
            throw new IllegalArgumentException("Cannot remove tasks for non-existing connector");
        }
        HashSet<ConnectorTaskId> taskIds = new HashSet<ConnectorTaskId>(state.taskConfigs.keySet());
        state.taskConfigs.clear();
        if (this.updateListener != null) {
            this.updateListener.onTaskConfigUpdate(taskIds);
        }
    }

    @Override
    public synchronized void putTaskConfigs(String connector, List<Map<String, String>> configs) {
        ConnectorState state = this.connectors.get(connector);
        if (state == null) {
            throw new IllegalArgumentException("Cannot put tasks for non-existing connector");
        }
        Map<ConnectorTaskId, Map<String, String>> taskConfigsMap = MemoryConfigBackingStore.taskConfigListAsMap(connector, configs);
        state.taskConfigs = taskConfigsMap;
        if (this.updateListener != null) {
            this.updateListener.onTaskConfigUpdate(taskConfigsMap.keySet());
        }
    }

    @Override
    public void refresh(long timeout, TimeUnit unit) {
    }

    @Override
    public synchronized void putTargetState(String connector, TargetState state) {
        ConnectorState connectorState = this.connectors.get(connector);
        if (connectorState == null) {
            throw new IllegalArgumentException("No connector `" + connector + "` configured");
        }
        connectorState.targetState = state;
        if (this.updateListener != null) {
            this.updateListener.onConnectorTargetStateChange(connector);
        }
    }

    @Override
    public void putSessionKey(SessionKey sessionKey) {
    }

    @Override
    public void putRestartRequest(RestartRequest restartRequest) {
    }

    @Override
    public void putTaskCountRecord(String connector, int taskCount) {
    }

    @Override
    public synchronized void setUpdateListener(ConfigBackingStore.UpdateListener listener) {
        this.updateListener = listener;
    }

    private static Map<ConnectorTaskId, Map<String, String>> taskConfigListAsMap(String connector, List<Map<String, String>> configs) {
        int index = 0;
        TreeMap<ConnectorTaskId, Map<String, String>> result = new TreeMap<ConnectorTaskId, Map<String, String>>();
        for (Map<String, String> taskConfigMap : configs) {
            result.put(new ConnectorTaskId(connector, index++), taskConfigMap);
        }
        return result;
    }

    private static class ConnectorState {
        private TargetState targetState = TargetState.STARTED;
        private Map<String, String> connConfig;
        private Map<ConnectorTaskId, Map<String, String>> taskConfigs;

        public ConnectorState(Map<String, String> connConfig) {
            this.connConfig = connConfig;
            this.taskConfigs = new HashMap<ConnectorTaskId, Map<String, String>>();
        }
    }
}

