/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.errors.AlreadyExistsException;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.AbstractHerder;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.HerderConnectorContext;
import org.apache.kafka.connect.runtime.SinkConnectorConfig;
import org.apache.kafka.connect.runtime.SourceConnectorConfig;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.kafka.connect.runtime.distributed.ConnectProtocol;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.distributed.NotAssignedException;
import org.apache.kafka.connect.runtime.distributed.NotLeaderException;
import org.apache.kafka.connect.runtime.distributed.RebalanceNeededException;
import org.apache.kafka.connect.runtime.distributed.WorkerGroupMember;
import org.apache.kafka.connect.runtime.distributed.WorkerRebalanceListener;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.TaskInfo;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.SinkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedHerder
extends AbstractHerder
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DistributedHerder.class);
    private static final long RECONFIGURE_CONNECTOR_TASKS_BACKOFF_MS = 250L;
    private static final int START_STOP_THREAD_POOL_SIZE = 8;
    private final AtomicLong requestSeqNum = new AtomicLong();
    private final Time time;
    private final String workerGroupId;
    private final int workerSyncTimeoutMs;
    private final long workerTasksShutdownTimeoutMs;
    private final int workerUnsyncBackoffMs;
    private final ExecutorService herderExecutor;
    private final ExecutorService forwardRequestExecutor;
    private final ExecutorService startAndStopExecutor;
    private final WorkerGroupMember member;
    private final AtomicBoolean stopping;
    private boolean rebalanceResolved;
    private ConnectProtocol.Assignment assignment;
    private boolean canReadConfigs;
    private ClusterConfigState configState;
    final NavigableSet<HerderRequest> requests = new ConcurrentSkipListSet<HerderRequest>();
    private Set<String> connectorConfigUpdates = new HashSet<String>();
    private Set<String> connectorTargetStateChanges = new HashSet<String>();
    private boolean needsReconfigRebalance;
    private volatile int generation;

    public DistributedHerder(DistributedConfig config, Time time, Worker worker, StatusBackingStore statusBackingStore, ConfigBackingStore configBackingStore, String restUrl) {
        this(config, worker, worker.workerId(), statusBackingStore, configBackingStore, null, restUrl, time);
        configBackingStore.setUpdateListener(new ConfigUpdateListener());
    }

    DistributedHerder(DistributedConfig config, Worker worker, String workerId, StatusBackingStore statusBackingStore, ConfigBackingStore configBackingStore, WorkerGroupMember member, String restUrl, Time time) {
        super(worker, workerId, statusBackingStore, configBackingStore);
        this.time = time;
        this.workerGroupId = config.getString("group.id");
        this.workerSyncTimeoutMs = config.getInt("worker.sync.timeout.ms");
        this.workerTasksShutdownTimeoutMs = config.getLong("task.shutdown.graceful.timeout.ms");
        this.workerUnsyncBackoffMs = config.getInt("worker.unsync.backoff.ms");
        this.member = member != null ? member : new WorkerGroupMember(config, restUrl, this.configBackingStore, new RebalanceListener(), time);
        this.herderExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable herder) {
                return new Thread(herder, "DistributedHerder");
            }
        });
        this.forwardRequestExecutor = Executors.newSingleThreadExecutor();
        this.startAndStopExecutor = Executors.newFixedThreadPool(8);
        this.stopping = new AtomicBoolean(false);
        this.configState = ClusterConfigState.EMPTY;
        this.rebalanceResolved = true;
        this.needsReconfigRebalance = false;
        this.canReadConfigs = true;
    }

    @Override
    public void start() {
        this.herderExecutor.submit(this);
    }

    @Override
    public void run() {
        try {
            log.info("Herder starting");
            this.startServices();
            log.info("Herder started");
            while (!this.stopping.get()) {
                this.tick();
            }
            this.halt();
            log.info("Herder stopped");
        }
        catch (Throwable t) {
            log.error("Uncaught exception in herder work thread, exiting: ", t);
            Exit.exit((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        HerderRequest next;
        try {
            if (!this.canReadConfigs && !this.readConfigToEnd(this.workerSyncTimeoutMs)) {
                return;
            }
            this.member.ensureActive();
            if (!this.handleRebalanceCompleted()) {
                return;
            }
        }
        catch (WakeupException e) {
            return;
        }
        long now = this.time.milliseconds();
        long nextRequestTimeoutMs = Long.MAX_VALUE;
        while ((next = this.peekWithoutException()) != null) {
            if (now < next.at) {
                nextRequestTimeoutMs = next.at - now;
                break;
            }
            this.requests.pollFirst();
            try {
                next.action().call();
                next.callback().onCompletion(null, null);
            }
            catch (Throwable t) {
                next.callback().onCompletion(t, null);
            }
        }
        Set<String> connectorConfigUpdatesCopy = null;
        Set<String> connectorTargetStateChangesCopy = null;
        DistributedHerder distributedHerder = this;
        synchronized (distributedHerder) {
            if (this.needsReconfigRebalance || !this.connectorConfigUpdates.isEmpty() || !this.connectorTargetStateChanges.isEmpty()) {
                this.configState = this.configBackingStore.snapshot();
                if (this.needsReconfigRebalance) {
                    this.member.requestRejoin();
                    this.connectorConfigUpdates.clear();
                    this.connectorTargetStateChanges.clear();
                    this.needsReconfigRebalance = false;
                    return;
                }
                if (!this.connectorConfigUpdates.isEmpty()) {
                    connectorConfigUpdatesCopy = this.connectorConfigUpdates;
                    this.connectorConfigUpdates = new HashSet<String>();
                }
                if (!this.connectorTargetStateChanges.isEmpty()) {
                    connectorTargetStateChangesCopy = this.connectorTargetStateChanges;
                    this.connectorTargetStateChanges = new HashSet<String>();
                }
            }
        }
        if (connectorConfigUpdatesCopy != null) {
            this.processConnectorConfigUpdates(connectorConfigUpdatesCopy);
        }
        if (connectorTargetStateChangesCopy != null) {
            this.processTargetStateChanges(connectorTargetStateChangesCopy);
        }
        try {
            this.member.poll(nextRequestTimeoutMs);
            this.handleRebalanceCompleted();
        }
        catch (WakeupException wakeupException) {
            // empty catch block
        }
    }

    private void processConnectorConfigUpdates(Set<String> connectorConfigUpdates) {
        HashSet<String> localConnectors = this.assignment == null ? Collections.emptySet() : new HashSet<String>(this.assignment.connectors());
        for (String connectorName : connectorConfigUpdates) {
            if (!localConnectors.contains(connectorName)) continue;
            boolean remains = this.configState.contains(connectorName);
            log.info("Handling connector-only config update by {} connector {}", (Object)(remains ? "restarting" : "stopping"), (Object)connectorName);
            this.worker.stopConnector(connectorName);
            if (!remains) continue;
            this.startConnector(connectorName);
        }
    }

    private void processTargetStateChanges(Set<String> connectorTargetStateChanges) {
        for (String connector : connectorTargetStateChanges) {
            TargetState targetState = this.configState.targetState(connector);
            if (!this.configState.connectors().contains(connector)) {
                log.debug("Received target state change for unknown connector: {}", (Object)connector);
                continue;
            }
            this.worker.setTargetState(connector, targetState);
            if (targetState != TargetState.STARTED) continue;
            this.reconfigureConnectorTasksWithRetry(connector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        DistributedHerder distributedHerder = this;
        synchronized (distributedHerder) {
            log.info("Stopping connectors and tasks that are still assigned to this worker.");
            ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
            for (String connectorName : new ArrayList<String>(this.worker.connectorNames())) {
                callables.add(this.getConnectorStoppingCallable(connectorName));
            }
            for (ConnectorTaskId taskId : new ArrayList<ConnectorTaskId>(this.worker.taskIds())) {
                callables.add(this.getTaskStoppingCallable(taskId));
            }
            this.startAndStop(callables);
            this.member.stop();
            HerderRequest request = this.requests.pollFirst();
            while (request != null) {
                request.callback().onCompletion(new ConnectException("Worker is shutting down"), null);
                request = this.requests.pollFirst();
            }
            this.stopServices();
        }
    }

    @Override
    public void stop() {
        log.info("Herder stopping");
        this.stopping.set(true);
        this.member.wakeup();
        this.herderExecutor.shutdown();
        try {
            if (!this.herderExecutor.awaitTermination(this.workerTasksShutdownTimeoutMs, TimeUnit.MILLISECONDS)) {
                this.herderExecutor.shutdownNow();
            }
            this.forwardRequestExecutor.shutdown();
            this.startAndStopExecutor.shutdown();
            if (!this.forwardRequestExecutor.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                this.forwardRequestExecutor.shutdownNow();
            }
            if (!this.startAndStopExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                this.startAndStopExecutor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info("Herder stopped");
    }

    @Override
    public void connectors(final Callback<Collection<String>> callback) {
        log.trace("Submitting connector listing request");
        this.addRequest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (DistributedHerder.this.checkRebalanceNeeded(callback)) {
                    return null;
                }
                callback.onCompletion(null, DistributedHerder.this.configState.connectors());
                return null;
            }
        }, DistributedHerder.forwardErrorCallback(callback));
    }

    @Override
    public void connectorInfo(final String connName, final Callback<ConnectorInfo> callback) {
        log.trace("Submitting connector info request {}", (Object)connName);
        this.addRequest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (DistributedHerder.this.checkRebalanceNeeded(callback)) {
                    return null;
                }
                if (!DistributedHerder.this.configState.contains(connName)) {
                    callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
                } else {
                    callback.onCompletion(null, new ConnectorInfo(connName, DistributedHerder.this.configState.connectorConfig(connName), DistributedHerder.this.configState.tasks(connName)));
                }
                return null;
            }
        }, DistributedHerder.forwardErrorCallback(callback));
    }

    @Override
    public void connectorConfig(String connName, final Callback<Map<String, String>> callback) {
        log.trace("Submitting connector config read request {}", (Object)connName);
        this.connectorInfo(connName, new Callback<ConnectorInfo>(){

            @Override
            public void onCompletion(Throwable error, ConnectorInfo result) {
                if (error != null) {
                    callback.onCompletion(error, null);
                } else {
                    callback.onCompletion(null, result.config());
                }
            }
        });
    }

    @Override
    public void deleteConnectorConfig(final String connName, final Callback<Herder.Created<ConnectorInfo>> callback) {
        this.addRequest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                log.trace("Handling connector config request {}", (Object)connName);
                if (!DistributedHerder.this.isLeader()) {
                    callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can set connector configs.", DistributedHerder.this.leaderUrl())), null);
                    return null;
                }
                if (!DistributedHerder.this.configState.contains(connName)) {
                    callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
                } else {
                    log.trace("Removing connector config {} {}", (Object)connName, DistributedHerder.this.configState.connectors());
                    DistributedHerder.this.configBackingStore.removeConnectorConfig(connName);
                    callback.onCompletion(null, new Herder.Created<Object>(false, null));
                }
                return null;
            }
        }, DistributedHerder.forwardErrorCallback(callback));
    }

    @Override
    protected Map<String, ConfigValue> validateBasicConnectorConfig(Connector connector, ConfigDef configDef, Map<String, String> config) {
        ConfigValue validatedName;
        String name;
        Map<String, ConfigValue> validatedConfig = super.validateBasicConnectorConfig(connector, configDef, config);
        if (connector instanceof SinkConnector && this.workerGroupId.equals(SinkUtils.consumerGroupId(name = (String)(validatedName = validatedConfig.get("name")).value()))) {
            validatedName.addErrorMessage("Consumer group for sink connector named " + name + " conflicts with Connect worker group " + this.workerGroupId);
        }
        return validatedConfig;
    }

    @Override
    public void putConnectorConfig(final String connName, final Map<String, String> config, final boolean allowReplace, final Callback<Herder.Created<ConnectorInfo>> callback) {
        log.trace("Submitting connector config write request {}", (Object)connName);
        this.addRequest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (DistributedHerder.this.maybeAddConfigErrors(DistributedHerder.this.validateConnectorConfig(config), callback)) {
                    return null;
                }
                log.trace("Handling connector config request {}", (Object)connName);
                if (!DistributedHerder.this.isLeader()) {
                    callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader can set connector configs.", DistributedHerder.this.leaderUrl())), null);
                    return null;
                }
                boolean exists = DistributedHerder.this.configState.contains(connName);
                if (!allowReplace && exists) {
                    callback.onCompletion((Throwable)new AlreadyExistsException("Connector " + connName + " already exists"), null);
                    return null;
                }
                log.trace("Submitting connector config {} {} {}", new Object[]{connName, allowReplace, DistributedHerder.this.configState.connectors()});
                DistributedHerder.this.configBackingStore.putConnectorConfig(connName, config);
                ConnectorInfo info = new ConnectorInfo(connName, config, DistributedHerder.this.configState.tasks(connName));
                callback.onCompletion(null, new Herder.Created<ConnectorInfo>(!exists, info));
                return null;
            }
        }, DistributedHerder.forwardErrorCallback(callback));
    }

    @Override
    public void requestTaskReconfiguration(final String connName) {
        log.trace("Submitting connector task reconfiguration request {}", (Object)connName);
        this.addRequest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DistributedHerder.this.reconfigureConnectorTasksWithRetry(connName);
                return null;
            }
        }, new Callback<Void>(){

            @Override
            public void onCompletion(Throwable error, Void result) {
                if (error != null) {
                    log.error("Unexpected error during task reconfiguration: ", error);
                    log.error("Task reconfiguration for {} failed unexpectedly, this connector will not be properly reconfigured unless manually triggered.", (Object)connName);
                }
            }
        });
    }

    @Override
    public void taskConfigs(final String connName, final Callback<List<TaskInfo>> callback) {
        log.trace("Submitting get task configuration request {}", (Object)connName);
        this.addRequest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (DistributedHerder.this.checkRebalanceNeeded(callback)) {
                    return null;
                }
                if (!DistributedHerder.this.configState.contains(connName)) {
                    callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
                } else {
                    ArrayList<TaskInfo> result = new ArrayList<TaskInfo>();
                    for (int i = 0; i < DistributedHerder.this.configState.taskCount(connName); ++i) {
                        ConnectorTaskId id = new ConnectorTaskId(connName, i);
                        result.add(new TaskInfo(id, DistributedHerder.this.configState.taskConfig(id)));
                    }
                    callback.onCompletion(null, result);
                }
                return null;
            }
        }, DistributedHerder.forwardErrorCallback(callback));
    }

    @Override
    public void putTaskConfigs(final String connName, final List<Map<String, String>> configs, final Callback<Void> callback) {
        log.trace("Submitting put task configuration request {}", (Object)connName);
        this.addRequest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!DistributedHerder.this.isLeader()) {
                    callback.onCompletion((Throwable)((Object)new NotLeaderException("Only the leader may write task configurations.", DistributedHerder.this.leaderUrl())), null);
                } else if (!DistributedHerder.this.configState.contains(connName)) {
                    callback.onCompletion((Throwable)new NotFoundException("Connector " + connName + " not found"), null);
                } else {
                    DistributedHerder.this.configBackingStore.putTaskConfigs(connName, configs);
                    callback.onCompletion(null, null);
                }
                return null;
            }
        }, DistributedHerder.forwardErrorCallback(callback));
    }

    @Override
    public void restartConnector(final String connName, final Callback<Void> callback) {
        this.addRequest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                block9: {
                    if (DistributedHerder.this.checkRebalanceNeeded(callback)) {
                        return null;
                    }
                    if (!DistributedHerder.this.configState.connectors().contains(connName)) {
                        callback.onCompletion((Throwable)new NotFoundException("Unknown connector: " + connName), null);
                        return null;
                    }
                    if (DistributedHerder.this.assignment.connectors().contains(connName)) {
                        try {
                            DistributedHerder.this.worker.stopConnector(connName);
                            if (DistributedHerder.this.startConnector(connName)) {
                                callback.onCompletion(null, null);
                                break block9;
                            }
                            callback.onCompletion(new ConnectException("Failed to start connector: " + connName), null);
                        }
                        catch (Throwable t) {
                            callback.onCompletion(t, null);
                        }
                    } else if (DistributedHerder.this.isLeader()) {
                        callback.onCompletion((Throwable)((Object)new NotAssignedException("Cannot restart connector since it is not assigned to this member", DistributedHerder.this.member.ownerUrl(connName))), null);
                    } else {
                        callback.onCompletion((Throwable)((Object)new NotLeaderException("Cannot restart connector since it is not assigned to this member", DistributedHerder.this.leaderUrl())), null);
                    }
                }
                return null;
            }
        }, DistributedHerder.forwardErrorCallback(callback));
    }

    @Override
    public void restartTask(final ConnectorTaskId id, final Callback<Void> callback) {
        this.addRequest(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                block10: {
                    if (DistributedHerder.this.checkRebalanceNeeded(callback)) {
                        return null;
                    }
                    if (!DistributedHerder.this.configState.connectors().contains(id.connector())) {
                        callback.onCompletion((Throwable)new NotFoundException("Unknown connector: " + id.connector()), null);
                        return null;
                    }
                    if (DistributedHerder.this.configState.taskConfig(id) == null) {
                        callback.onCompletion((Throwable)new NotFoundException("Unknown task: " + id), null);
                        return null;
                    }
                    if (DistributedHerder.this.assignment.tasks().contains(id)) {
                        try {
                            DistributedHerder.this.worker.stopAndAwaitTask(id);
                            if (DistributedHerder.this.startTask(id)) {
                                callback.onCompletion(null, null);
                                break block10;
                            }
                            callback.onCompletion(new ConnectException("Failed to start task: " + id), null);
                        }
                        catch (Throwable t) {
                            callback.onCompletion(t, null);
                        }
                    } else if (DistributedHerder.this.isLeader()) {
                        callback.onCompletion((Throwable)((Object)new NotAssignedException("Cannot restart task since it is not assigned to this member", DistributedHerder.this.member.ownerUrl(id))), null);
                    } else {
                        callback.onCompletion((Throwable)((Object)new NotLeaderException("Cannot restart task since it is not assigned to this member", DistributedHerder.this.leaderUrl())), null);
                    }
                }
                return null;
            }
        }, DistributedHerder.forwardErrorCallback(callback));
    }

    @Override
    public int generation() {
        return this.generation;
    }

    private boolean isLeader() {
        return this.assignment != null && this.member.memberId().equals(this.assignment.leader());
    }

    private String leaderUrl() {
        if (this.assignment == null) {
            return null;
        }
        return this.assignment.leaderUrl();
    }

    private boolean handleRebalanceCompleted() {
        if (this.rebalanceResolved) {
            return true;
        }
        boolean needsReadToEnd = false;
        boolean needsRejoin = false;
        if (this.assignment.failed()) {
            needsRejoin = true;
            if (this.isLeader()) {
                log.warn("Join group completed, but assignment failed and we are the leader. Reading to end of config and retrying.");
                needsReadToEnd = true;
            } else if (this.configState.offset() < this.assignment.offset()) {
                log.warn("Join group completed, but assignment failed and we lagging. Reading to end of config and retrying.");
                needsReadToEnd = true;
            } else {
                log.warn("Join group completed, but assignment failed. We were up to date, so just retrying.");
            }
        } else if (this.configState.offset() < this.assignment.offset()) {
            log.warn("Catching up to assignment's config offset.");
            needsReadToEnd = true;
        }
        if (needsReadToEnd && !this.readConfigToEnd(this.workerSyncTimeoutMs)) {
            this.canReadConfigs = false;
            needsRejoin = true;
        }
        if (needsRejoin) {
            this.member.requestRejoin();
            return false;
        }
        if (this.configState.offset() != this.assignment.offset()) {
            log.info("Current config state offset {} does not match group assignment {}. Forcing rebalance.", (Object)this.configState.offset(), (Object)this.assignment.offset());
            this.member.requestRejoin();
            return false;
        }
        this.startWork();
        this.rebalanceResolved = true;
        return true;
    }

    private boolean readConfigToEnd(long timeoutMs) {
        log.info("Current config state offset {} is behind group assignment {}, reading to end of config log", (Object)this.configState.offset(), (Object)this.assignment.offset());
        try {
            this.configBackingStore.refresh(timeoutMs, TimeUnit.MILLISECONDS);
            this.configState = this.configBackingStore.snapshot();
            log.info("Finished reading to end of log and updated config snapshot, new config log offset: {}", (Object)this.configState.offset());
            return true;
        }
        catch (TimeoutException e) {
            log.warn("Didn't reach end of config log quickly enough", (Throwable)e);
            this.member.maybeLeaveGroup();
            this.backoff(this.workerUnsyncBackoffMs);
            return false;
        }
    }

    private void backoff(long ms) {
        Utils.sleep((long)ms);
    }

    private void startAndStop(Collection<Callable<Void>> callables) {
        try {
            this.startAndStopExecutor.invokeAll(callables);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void startWork() {
        log.info("Starting connectors and tasks using config offset {}", (Object)this.assignment.offset());
        ArrayList<Callable<Void>> callables = new ArrayList<Callable<Void>>();
        for (String connectorName : this.assignment.connectors()) {
            callables.add(this.getConnectorStartingCallable(connectorName));
        }
        for (ConnectorTaskId taskId : this.assignment.tasks()) {
            callables.add(this.getTaskStartingCallable(taskId));
        }
        this.startAndStop(callables);
        log.info("Finished starting connectors and tasks");
    }

    private boolean startTask(ConnectorTaskId taskId) {
        log.info("Starting task {}", (Object)taskId);
        return this.worker.startTask(taskId, this.configState.connectorConfig(taskId.connector()), this.configState.taskConfig(taskId), this, this.configState.targetState(taskId.connector()));
    }

    private Callable<Void> getTaskStartingCallable(final ConnectorTaskId taskId) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    DistributedHerder.this.startTask(taskId);
                }
                catch (Throwable t) {
                    log.error("Couldn't instantiate task {} because it has an invalid task configuration. This task will not execute until reconfigured.", (Object)taskId, (Object)t);
                    DistributedHerder.this.onFailure(taskId, t);
                }
                return null;
            }
        };
    }

    private Callable<Void> getTaskStoppingCallable(final ConnectorTaskId taskId) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DistributedHerder.this.worker.stopAndAwaitTask(taskId);
                return null;
            }
        };
    }

    private boolean startConnector(String connectorName) {
        log.info("Starting connector {}", (Object)connectorName);
        Map<String, String> configProps = this.configState.connectorConfig(connectorName);
        HerderConnectorContext ctx = new HerderConnectorContext(this, connectorName);
        TargetState initialState = this.configState.targetState(connectorName);
        boolean started = this.worker.startConnector(connectorName, configProps, ctx, this, initialState);
        if (started && initialState == TargetState.STARTED) {
            this.reconfigureConnectorTasksWithRetry(connectorName);
        }
        return started;
    }

    private Callable<Void> getConnectorStartingCallable(final String connectorName) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    DistributedHerder.this.startConnector(connectorName);
                }
                catch (Throwable t) {
                    log.error("Couldn't instantiate connector " + connectorName + " because it has an invalid connector " + "configuration. This connector will not execute until reconfigured.", t);
                    DistributedHerder.this.onFailure(connectorName, t);
                }
                return null;
            }
        };
    }

    private Callable<Void> getConnectorStoppingCallable(final String connectorName) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    DistributedHerder.this.worker.stopConnector(connectorName);
                }
                catch (Throwable t) {
                    log.error("Failed to shut down connector " + connectorName, t);
                }
                return null;
            }
        };
    }

    private void reconfigureConnectorTasksWithRetry(final String connName) {
        this.reconfigureConnector(connName, new Callback<Void>(){

            @Override
            public void onCompletion(Throwable error, Void result) {
                if (error != null) {
                    log.error("Failed to reconfigure connector's tasks, retrying after backoff:", error);
                    DistributedHerder.this.addRequest(250L, new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            DistributedHerder.this.reconfigureConnectorTasksWithRetry(connName);
                            return null;
                        }
                    }, new Callback<Void>(){

                        @Override
                        public void onCompletion(Throwable error, Void result) {
                            log.error("Unexpected error during connector task reconfiguration: ", error);
                            log.error("Task reconfiguration for {} failed unexpectedly, this connector will not be properly reconfigured unless manually triggered.", (Object)connName);
                        }
                    });
                }
            }
        });
    }

    private void reconfigureConnector(final String connName, final Callback<Void> cb) {
        try {
            ConnectorConfig connConfig;
            if (!this.worker.isRunning(connName)) {
                log.info("Skipping reconfiguration of connector {} since it is not running", (Object)connName);
                return;
            }
            Map<String, String> configs = this.configState.connectorConfig(connName);
            List sinkTopics = null;
            if (this.worker.isSinkConnector(connName)) {
                connConfig = new SinkConnectorConfig(this.plugins(), configs);
                sinkTopics = connConfig.getList("topics");
            } else {
                connConfig = new SourceConnectorConfig(this.plugins(), configs);
            }
            final List<Map<String, String>> taskProps = this.worker.connectorTaskConfigs(connName, connConfig.getInt("tasks.max"), sinkTopics);
            boolean changed = false;
            int currentNumTasks = this.configState.taskCount(connName);
            if (taskProps.size() != currentNumTasks) {
                log.debug("Change in connector task count from {} to {}, writing updated task configurations", (Object)currentNumTasks, (Object)taskProps.size());
                changed = true;
            } else {
                int index = 0;
                for (Map<String, String> taskConfig : taskProps) {
                    if (!taskConfig.equals(this.configState.taskConfig(new ConnectorTaskId(connName, index)))) {
                        log.debug("Change in task configurations, writing updated task configurations");
                        changed = true;
                        break;
                    }
                    ++index;
                }
            }
            if (changed) {
                if (this.isLeader()) {
                    this.configBackingStore.putTaskConfigs(connName, taskProps);
                    cb.onCompletion(null, null);
                } else {
                    this.forwardRequestExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String reconfigUrl = RestServer.urlJoin(DistributedHerder.this.leaderUrl(), "/connectors/" + connName + "/tasks");
                                RestServer.httpRequest(reconfigUrl, "POST", taskProps, null);
                                cb.onCompletion(null, null);
                            }
                            catch (ConnectException e) {
                                log.error("Request to leader to reconfigure connector tasks failed", (Throwable)e);
                                cb.onCompletion(e, null);
                            }
                        }
                    });
                }
            }
        }
        catch (Throwable t) {
            cb.onCompletion(t, null);
        }
    }

    private boolean checkRebalanceNeeded(Callback<?> callback) {
        if (this.needsReconfigRebalance) {
            callback.onCompletion((Throwable)((Object)new RebalanceNeededException("Request cannot be completed because a rebalance is expected")), null);
            return true;
        }
        return false;
    }

    HerderRequest addRequest(Callable<Void> action, Callback<Void> callback) {
        return this.addRequest(0L, action, callback);
    }

    HerderRequest addRequest(long delayMs, Callable<Void> action, Callback<Void> callback) {
        HerderRequest req = new HerderRequest(this.time.milliseconds() + delayMs, this.requestSeqNum.incrementAndGet(), action, callback);
        this.requests.add(req);
        if (this.peekWithoutException() == req) {
            this.member.wakeup();
        }
        return req;
    }

    private HerderRequest peekWithoutException() {
        try {
            return this.requests.isEmpty() ? null : (HerderRequest)this.requests.first();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private static final Callback<Void> forwardErrorCallback(final Callback<?> callback) {
        return new Callback<Void>(){

            @Override
            public void onCompletion(Throwable error, Void result) {
                if (error != null) {
                    callback.onCompletion(error, null);
                }
            }
        };
    }

    private void updateDeletedConnectorStatus() {
        ClusterConfigState snapshot = this.configBackingStore.snapshot();
        Set<String> connectors = snapshot.connectors();
        for (String connector : this.statusBackingStore.connectors()) {
            if (connectors.contains(connector)) continue;
            log.debug("Cleaning status information for connector {}", (Object)connector);
            this.onDeletion(connector);
        }
    }

    public class RebalanceListener
    implements WorkerRebalanceListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAssigned(ConnectProtocol.Assignment assignment, int generation) {
            log.info("Joined group and got assignment: {}", (Object)assignment);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                DistributedHerder.this.assignment = assignment;
                DistributedHerder.this.generation = generation;
                DistributedHerder.this.rebalanceResolved = false;
            }
            if (DistributedHerder.this.isLeader()) {
                DistributedHerder.this.updateDeletedConnectorStatus();
            }
            DistributedHerder.this.member.wakeup();
        }

        @Override
        public void onRevoked(String leader, Collection<String> connectors, Collection<ConnectorTaskId> tasks) {
            log.info("Rebalance started");
            if (DistributedHerder.this.rebalanceResolved) {
                ArrayList<Callable> callables = new ArrayList<Callable>();
                for (String connectorName : connectors) {
                    callables.add(DistributedHerder.this.getConnectorStoppingCallable(connectorName));
                }
                for (ConnectorTaskId taskId : tasks) {
                    callables.add(DistributedHerder.this.getTaskStoppingCallable(taskId));
                }
                DistributedHerder.this.startAndStop(callables);
                DistributedHerder.this.statusBackingStore.flush();
                log.info("Finished stopping tasks in preparation for rebalance");
            } else {
                log.info("Wasn't unable to resume work after last rebalance, can skip stopping connectors and tasks");
            }
        }
    }

    static class HerderRequest
    implements Comparable<HerderRequest> {
        private final long at;
        private final long seq;
        private final Callable<Void> action;
        private final Callback<Void> callback;

        public HerderRequest(long at, long seq, Callable<Void> action, Callback<Void> callback) {
            this.at = at;
            this.seq = seq;
            this.action = action;
            this.callback = callback;
        }

        public Callable<Void> action() {
            return this.action;
        }

        public Callback<Void> callback() {
            return this.callback;
        }

        @Override
        public int compareTo(HerderRequest o) {
            int cmp = Long.compare(this.at, o.at);
            return cmp == 0 ? Long.compare(this.seq, o.seq) : cmp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HerderRequest)) {
                return false;
            }
            HerderRequest other = (HerderRequest)o;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.at, this.seq);
        }
    }

    public class ConfigUpdateListener
    implements ConfigBackingStore.UpdateListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectorConfigRemove(String connector) {
            log.info("Connector {} config removed", (Object)connector);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                if (DistributedHerder.this.configState.contains(connector)) {
                    DistributedHerder.this.needsReconfigRebalance = true;
                }
                DistributedHerder.this.connectorConfigUpdates.add(connector);
            }
            DistributedHerder.this.member.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectorConfigUpdate(String connector) {
            log.info("Connector {} config updated", (Object)connector);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                if (!DistributedHerder.this.configState.contains(connector)) {
                    DistributedHerder.this.needsReconfigRebalance = true;
                }
                DistributedHerder.this.connectorConfigUpdates.add(connector);
            }
            DistributedHerder.this.member.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTaskConfigUpdate(Collection<ConnectorTaskId> tasks) {
            log.info("Tasks {} configs updated", tasks);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                DistributedHerder.this.needsReconfigRebalance = true;
            }
            DistributedHerder.this.member.wakeup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectorTargetStateChange(String connector) {
            log.info("Connector {} target state change", (Object)connector);
            DistributedHerder distributedHerder = DistributedHerder.this;
            synchronized (distributedHerder) {
                DistributedHerder.this.connectorTargetStateChanges.add(connector);
            }
            DistributedHerder.this.member.wakeup();
        }
    }
}

