/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.rest.basic.auth.extension;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.kafka.connect.rest.ConnectRestExtensionContext;
import org.apache.kafka.connect.rest.basic.auth.extension.JaasBasicAuthFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthSecurityRestExtension
implements ConnectRestExtension {
    private static final Logger log = LoggerFactory.getLogger(BasicAuthSecurityRestExtension.class);
    private static final Supplier<Configuration> CONFIGURATION = BasicAuthSecurityRestExtension.initializeConfiguration(Configuration::getConfiguration);
    private final Supplier<Configuration> configuration;

    static Supplier<Configuration> initializeConfiguration(Supplier<Configuration> configurationSupplier) {
        try {
            Configuration configuration = configurationSupplier.get();
            return () -> configuration;
        }
        catch (Exception e) {
            return () -> {
                throw new ConnectException("Failed to retrieve JAAS configuration", (Throwable)e);
            };
        }
    }

    public BasicAuthSecurityRestExtension() {
        this(CONFIGURATION);
    }

    BasicAuthSecurityRestExtension(Supplier<Configuration> configuration) {
        this.configuration = configuration;
    }

    public void register(ConnectRestExtensionContext restPluginContext) {
        log.trace("Registering JAAS basic auth filter");
        restPluginContext.configurable().register((Object)new JaasBasicAuthFilter(this.configuration.get()));
        log.trace("Finished registering JAAS basic auth filter");
    }

    public void close() throws IOException {
    }

    public void configure(Map<String, ?> configs) {
        this.configuration.get();
    }

    public String version() {
        return AppInfoParser.getVersion();
    }
}

