/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.source;

import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.connector.ConnectorTest;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceConnectorContext;
import org.apache.kafka.connect.storage.OffsetStorageReader;
import org.junit.jupiter.api.Assertions;

public class SourceConnectorTest
extends ConnectorTest {
    @Override
    protected ConnectorContext createContext() {
        return new TestSourceConnectorContext();
    }

    protected TestSourceConnector createConnector() {
        return new TestSourceConnector();
    }

    private static class TestSourceConnector
    extends SourceConnector
    implements ConnectorTest.AssertableConnector {
        public static final String VERSION = "an entirely different version";
        private boolean initialized;
        private List<Map<String, String>> taskConfigs;
        private Map<String, String> props;
        private boolean started;
        private boolean stopped;

        private TestSourceConnector() {
        }

        public String version() {
            return VERSION;
        }

        public void initialize(ConnectorContext ctx) {
            super.initialize(ctx);
            this.initialized = true;
            this.taskConfigs = null;
        }

        public void initialize(ConnectorContext ctx, List<Map<String, String>> taskConfigs) {
            super.initialize(ctx, taskConfigs);
            this.initialized = true;
            this.taskConfigs = taskConfigs;
        }

        public void start(Map<String, String> props) {
            this.props = props;
            this.started = true;
        }

        public Class<? extends Task> taskClass() {
            return null;
        }

        public List<Map<String, String>> taskConfigs(int maxTasks) {
            return null;
        }

        public void stop() {
            this.stopped = true;
        }

        public ConfigDef config() {
            return new ConfigDef().define("required", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "required docs").define("optional", ConfigDef.Type.STRING, (Object)"defaultVal", ConfigDef.Importance.HIGH, "optional docs");
        }

        @Override
        public void assertContext(ConnectorContext expected) {
            Assertions.assertSame((Object)expected, (Object)this.context);
            Assertions.assertSame((Object)expected, (Object)this.context());
        }

        @Override
        public void assertInitialized() {
            Assertions.assertTrue((boolean)this.initialized);
        }

        @Override
        public void assertTaskConfigs(List<Map<String, String>> expectedTaskConfigs) {
            Assertions.assertSame(expectedTaskConfigs, this.taskConfigs);
        }

        @Override
        public void assertStarted(boolean expected) {
            Assertions.assertEquals((Object)expected, (Object)this.started);
        }

        @Override
        public void assertStopped(boolean expected) {
            Assertions.assertEquals((Object)expected, (Object)this.stopped);
        }

        @Override
        public void assertProperties(Map<String, String> expected) {
            Assertions.assertSame(expected, this.props);
        }
    }

    private static class TestSourceConnectorContext
    implements SourceConnectorContext {
        private TestSourceConnectorContext() {
        }

        public void requestTaskReconfiguration() {
            throw new UnsupportedOperationException();
        }

        public void raiseError(Exception e) {
            throw new UnsupportedOperationException();
        }

        public OffsetStorageReader offsetStorageReader() {
            return null;
        }
    }
}

