/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConnectSchemaTest {
    private static final Schema MAP_INT_STRING_SCHEMA = SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.STRING_SCHEMA).build();
    private static final Schema FLAT_STRUCT_SCHEMA = SchemaBuilder.struct().field("field", Schema.INT32_SCHEMA).build();
    private static final Schema STRUCT_SCHEMA = SchemaBuilder.struct().field("first", Schema.INT32_SCHEMA).field("second", Schema.STRING_SCHEMA).field("array", SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build()).field("map", SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.STRING_SCHEMA).build()).field("nested", FLAT_STRUCT_SCHEMA).build();
    private static final Schema PARENT_STRUCT_SCHEMA = SchemaBuilder.struct().field("nested", FLAT_STRUCT_SCHEMA).build();

    @Test
    public void testFieldsOnStructSchema() {
        Schema schema = SchemaBuilder.struct().field("foo", Schema.BOOLEAN_SCHEMA).field("bar", Schema.INT32_SCHEMA).build();
        Assertions.assertEquals((int)2, (int)schema.fields().size());
        Field foo = schema.field("foo");
        Assertions.assertEquals((int)0, (int)foo.index());
        Field bar = schema.field("bar");
        Assertions.assertEquals((int)1, (int)bar.index());
        Assertions.assertNull((Object)schema.field("other"));
    }

    @Test
    public void testFieldsOnlyValidForStructs() {
        Assertions.assertThrows(DataException.class, () -> ((Schema)Schema.INT8_SCHEMA).fields());
    }

    @Test
    public void testValidateValueMatchingType() {
        ConnectSchema.validateValue((Schema)Schema.INT8_SCHEMA, (Object)1);
        ConnectSchema.validateValue((Schema)Schema.INT16_SCHEMA, (Object)1);
        ConnectSchema.validateValue((Schema)Schema.INT32_SCHEMA, (Object)1);
        ConnectSchema.validateValue((Schema)Schema.INT64_SCHEMA, (Object)1L);
        ConnectSchema.validateValue((Schema)Schema.FLOAT32_SCHEMA, (Object)Float.valueOf(1.0f));
        ConnectSchema.validateValue((Schema)Schema.FLOAT64_SCHEMA, (Object)1.0);
        ConnectSchema.validateValue((Schema)Schema.BOOLEAN_SCHEMA, (Object)true);
        ConnectSchema.validateValue((Schema)Schema.STRING_SCHEMA, (Object)"a string");
        ConnectSchema.validateValue((Schema)Schema.BYTES_SCHEMA, (Object)"a byte array".getBytes());
        ConnectSchema.validateValue((Schema)Schema.BYTES_SCHEMA, (Object)ByteBuffer.wrap("a byte array".getBytes()));
        ConnectSchema.validateValue((Schema)SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build(), Arrays.asList(1, 2, 3));
        ConnectSchema.validateValue((Schema)SchemaBuilder.map((Schema)Schema.INT32_SCHEMA, (Schema)Schema.STRING_SCHEMA).build(), Collections.singletonMap(1, "value"));
        Struct structValue = new Struct(STRUCT_SCHEMA).put("first", (Object)1).put("second", (Object)"foo").put("array", Arrays.asList(1, 2, 3)).put("map", Collections.singletonMap(1, "value")).put("nested", (Object)new Struct(FLAT_STRUCT_SCHEMA).put("field", (Object)12));
        ConnectSchema.validateValue((Schema)STRUCT_SCHEMA, (Object)structValue);
    }

    @Test
    public void testValidateValueMatchingLogicalType() {
        ConnectSchema.validateValue((Schema)Decimal.schema((int)2), (Object)new BigDecimal(new BigInteger("156"), 2));
        ConnectSchema.validateValue((Schema)Date.SCHEMA, (Object)new java.util.Date(0L));
        ConnectSchema.validateValue((Schema)Time.SCHEMA, (Object)new java.util.Date(0L));
        ConnectSchema.validateValue((Schema)Timestamp.SCHEMA, (Object)new java.util.Date(0L));
    }

    @Test
    public void testValidateValueMismatchInt8() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Schema.INT8_SCHEMA, (Object)1));
    }

    @Test
    public void testValidateValueMismatchInt16() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Schema.INT16_SCHEMA, (Object)1));
    }

    @Test
    public void testValidateValueMismatchInt32() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Schema.INT32_SCHEMA, (Object)1L));
    }

    @Test
    public void testValidateValueMismatchInt64() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Schema.INT64_SCHEMA, (Object)1));
    }

    @Test
    public void testValidateValueMismatchFloat() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Schema.FLOAT32_SCHEMA, (Object)1.0));
    }

    @Test
    public void testValidateValueMismatchDouble() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Schema.FLOAT64_SCHEMA, (Object)Float.valueOf(1.0f)));
    }

    @Test
    public void testValidateValueMismatchBoolean() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Schema.BOOLEAN_SCHEMA, (Object)Float.valueOf(1.0f)));
    }

    @Test
    public void testValidateValueMismatchString() {
        CharBuffer cbuf = CharBuffer.wrap("abc");
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Schema.STRING_SCHEMA, (Object)cbuf));
    }

    @Test
    public void testValidateValueMismatchBytes() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Schema.BYTES_SCHEMA, (Object)new Object[]{1, "foo"}));
    }

    @Test
    public void testValidateValueMismatchArray() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build(), Arrays.asList("a", "b", "c")));
    }

    @Test
    public void testValidateValueMismatchArraySomeMatch() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).build(), Arrays.asList(1, 2, "c")));
    }

    @Test
    public void testValidateValueMismatchMapKey() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)MAP_INT_STRING_SCHEMA, Collections.singletonMap("wrong key type", "value")));
    }

    @Test
    public void testValidateValueMismatchMapValue() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)MAP_INT_STRING_SCHEMA, Collections.singletonMap(1, 2)));
    }

    @Test
    public void testValidateValueMismatchMapSomeKeys() {
        HashMap<Object, String> data = new HashMap<Object, String>();
        data.put(1, "abc");
        data.put("wrong", "it's as easy as one two three");
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)MAP_INT_STRING_SCHEMA, (Object)data));
    }

    @Test
    public void testValidateValueMismatchMapSomeValues() {
        HashMap<Integer, Object> data = new HashMap<Integer, Object>();
        data.put(1, "abc");
        data.put(2, "wrong".getBytes());
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)MAP_INT_STRING_SCHEMA, (Object)data));
    }

    @Test
    public void testValidateValueMismatchStructWrongSchema() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)FLAT_STRUCT_SCHEMA, (Object)new Struct(SchemaBuilder.struct().field("x", Schema.INT32_SCHEMA).build()).put("x", (Object)1)));
    }

    @Test
    public void testValidateValueMismatchStructWrongNestedSchema() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)PARENT_STRUCT_SCHEMA, (Object)new Struct(PARENT_STRUCT_SCHEMA).put("nested", (Object)new Struct(SchemaBuilder.struct().field("x", Schema.INT32_SCHEMA).build()).put("x", (Object)1))));
    }

    @Test
    public void testValidateValueMismatchDecimal() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Decimal.schema((int)2), (Object)new BigInteger("156")));
    }

    @Test
    public void testValidateValueMismatchDate() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Date.SCHEMA, (Object)1000L));
    }

    @Test
    public void testValidateValueMismatchTime() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Time.SCHEMA, (Object)1000L));
    }

    @Test
    public void testValidateValueMismatchTimestamp() {
        Assertions.assertThrows(DataException.class, () -> ConnectSchema.validateValue((Schema)Timestamp.SCHEMA, (Object)1000L));
    }

    @Test
    public void testPrimitiveEquality() {
        ConnectSchema s1 = new ConnectSchema(Schema.Type.INT8, false, null, "name", Integer.valueOf(2), "doc");
        ConnectSchema s2 = new ConnectSchema(Schema.Type.INT8, false, null, "name", Integer.valueOf(2), "doc");
        ConnectSchema differentType = new ConnectSchema(Schema.Type.INT16, false, null, "name", Integer.valueOf(2), "doc");
        ConnectSchema differentOptional = new ConnectSchema(Schema.Type.INT8, true, null, "name", Integer.valueOf(2), "doc");
        ConnectSchema differentDefault = new ConnectSchema(Schema.Type.INT8, false, (Object)true, "name", Integer.valueOf(2), "doc");
        ConnectSchema differentName = new ConnectSchema(Schema.Type.INT8, false, null, "otherName", Integer.valueOf(2), "doc");
        ConnectSchema differentVersion = new ConnectSchema(Schema.Type.INT8, false, null, "name", Integer.valueOf(4), "doc");
        ConnectSchema differentDoc = new ConnectSchema(Schema.Type.INT8, false, null, "name", Integer.valueOf(2), "other doc");
        ConnectSchema differentParameters = new ConnectSchema(Schema.Type.INT8, false, null, "name", Integer.valueOf(2), "doc", Collections.singletonMap("param", "value"), null, null, null);
        Assertions.assertEquals((Object)s1, (Object)s2);
        Assertions.assertNotEquals((Object)s1, (Object)differentType);
        Assertions.assertNotEquals((Object)s1, (Object)differentOptional);
        Assertions.assertNotEquals((Object)s1, (Object)differentDefault);
        Assertions.assertNotEquals((Object)s1, (Object)differentName);
        Assertions.assertNotEquals((Object)s1, (Object)differentVersion);
        Assertions.assertNotEquals((Object)s1, (Object)differentDoc);
        Assertions.assertNotEquals((Object)s1, (Object)differentParameters);
    }

    @Test
    public void testArrayEquality() {
        ConnectSchema s1 = new ConnectSchema(Schema.Type.ARRAY, false, null, null, null, null, null, null, null, SchemaBuilder.int8().build());
        ConnectSchema s2 = new ConnectSchema(Schema.Type.ARRAY, false, null, null, null, null, null, null, null, SchemaBuilder.int8().build());
        ConnectSchema differentValueSchema = new ConnectSchema(Schema.Type.ARRAY, false, null, null, null, null, null, null, null, SchemaBuilder.int16().build());
        Assertions.assertEquals((Object)s1, (Object)s2);
        Assertions.assertNotEquals((Object)s1, (Object)differentValueSchema);
    }

    @Test
    public void testArrayDefaultValueEquality() {
        ConnectSchema s1 = new ConnectSchema(Schema.Type.ARRAY, false, (Object)new String[]{"a", "b"}, null, null, null, null, null, null, SchemaBuilder.int8().build());
        ConnectSchema s2 = new ConnectSchema(Schema.Type.ARRAY, false, (Object)new String[]{"a", "b"}, null, null, null, null, null, null, SchemaBuilder.int8().build());
        ConnectSchema differentValueSchema = new ConnectSchema(Schema.Type.ARRAY, false, (Object)new String[]{"b", "c"}, null, null, null, null, null, null, SchemaBuilder.int8().build());
        Assertions.assertEquals((Object)s1, (Object)s2);
        Assertions.assertNotEquals((Object)s1, (Object)differentValueSchema);
    }

    @Test
    public void testMapEquality() {
        ConnectSchema s1 = new ConnectSchema(Schema.Type.MAP, false, null, null, null, null, null, null, SchemaBuilder.int8().build(), SchemaBuilder.int16().build());
        ConnectSchema s2 = new ConnectSchema(Schema.Type.MAP, false, null, null, null, null, null, null, SchemaBuilder.int8().build(), SchemaBuilder.int16().build());
        ConnectSchema differentKeySchema = new ConnectSchema(Schema.Type.MAP, false, null, null, null, null, null, null, SchemaBuilder.string().build(), SchemaBuilder.int16().build());
        ConnectSchema differentValueSchema = new ConnectSchema(Schema.Type.MAP, false, null, null, null, null, null, null, SchemaBuilder.int8().build(), SchemaBuilder.string().build());
        Assertions.assertEquals((Object)s1, (Object)s2);
        Assertions.assertNotEquals((Object)s1, (Object)differentKeySchema);
        Assertions.assertNotEquals((Object)s1, (Object)differentValueSchema);
    }

    @Test
    public void testStructEquality() {
        ConnectSchema s1 = new ConnectSchema(Schema.Type.STRUCT, false, null, null, null, null, null, Arrays.asList(new Field("field", 0, SchemaBuilder.int8().build()), new Field("field2", 1, SchemaBuilder.int16().build())), null, null);
        ConnectSchema s2 = new ConnectSchema(Schema.Type.STRUCT, false, null, null, null, null, null, Arrays.asList(new Field("field", 0, SchemaBuilder.int8().build()), new Field("field2", 1, SchemaBuilder.int16().build())), null, null);
        ConnectSchema differentField = new ConnectSchema(Schema.Type.STRUCT, false, null, null, null, null, null, Arrays.asList(new Field("field", 0, SchemaBuilder.int8().build()), new Field("different field name", 1, SchemaBuilder.int16().build())), null, null);
        Assertions.assertEquals((Object)s1, (Object)s2);
        Assertions.assertNotEquals((Object)s1, (Object)differentField);
    }

    @Test
    public void testEmptyStruct() {
        ConnectSchema emptyStruct = new ConnectSchema(Schema.Type.STRUCT, false, null, null, null, null);
        Assertions.assertEquals((int)0, (int)emptyStruct.fields().size());
        new Struct((Schema)emptyStruct);
    }
}

