/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.DataException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimestampTest {
    private static final GregorianCalendar EPOCH = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    private static final GregorianCalendar EPOCH_PLUS_MILLIS;
    private static final int NUM_MILLIS = 2000000000;
    private static final long TOTAL_MILLIS = 4000000000L;

    @Test
    public void testBuilder() {
        Schema plain = Date.SCHEMA;
        Assertions.assertEquals((Object)"org.apache.kafka.connect.data.Date", (Object)plain.name());
        Assertions.assertEquals((Object)1, (Object)plain.version());
    }

    @Test
    public void testFromLogical() {
        Assertions.assertEquals((long)0L, (long)Timestamp.fromLogical((Schema)Timestamp.SCHEMA, (java.util.Date)EPOCH.getTime()));
        Assertions.assertEquals((long)4000000000L, (long)Timestamp.fromLogical((Schema)Timestamp.SCHEMA, (java.util.Date)EPOCH_PLUS_MILLIS.getTime()));
    }

    @Test
    public void testFromLogicalInvalidSchema() {
        Assertions.assertThrows(DataException.class, () -> Timestamp.fromLogical((Schema)Timestamp.builder().name("invalid").build(), (java.util.Date)EPOCH.getTime()));
    }

    @Test
    public void testToLogical() {
        Assertions.assertEquals((Object)EPOCH.getTime(), (Object)Timestamp.toLogical((Schema)Timestamp.SCHEMA, (long)0L));
        Assertions.assertEquals((Object)EPOCH_PLUS_MILLIS.getTime(), (Object)Timestamp.toLogical((Schema)Timestamp.SCHEMA, (long)4000000000L));
    }

    @Test
    public void testToLogicalInvalidSchema() {
        Assertions.assertThrows(DataException.class, () -> Date.toLogical((Schema)Date.builder().name("invalid").build(), (int)0));
    }

    static {
        EPOCH.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_MILLIS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_MILLIS.add(14, 2000000000);
        EPOCH_PLUS_MILLIS.add(14, 2000000000);
    }
}

