/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.source;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SourceRecordTest {
    private static final Map<String, ?> SOURCE_PARTITION = Collections.singletonMap("src", "abc");
    private static final Map<String, ?> SOURCE_OFFSET = Collections.singletonMap("offset", "1");
    private static final String TOPIC_NAME = "myTopic";
    private static final Integer PARTITION_NUMBER = 0;
    private static final Long KAFKA_TIMESTAMP = 0L;
    private SourceRecord record;

    @Before
    public void beforeEach() {
        this.record = new SourceRecord(SOURCE_PARTITION, SOURCE_OFFSET, TOPIC_NAME, PARTITION_NUMBER, Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, KAFKA_TIMESTAMP, null);
    }

    @Test
    public void shouldCreateSinkRecordWithHeaders() {
        Headers headers = new ConnectHeaders().addString("h1", "hv1").addBoolean("h2", true);
        this.record = new SourceRecord(SOURCE_PARTITION, SOURCE_OFFSET, TOPIC_NAME, PARTITION_NUMBER, Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, KAFKA_TIMESTAMP, (Iterable)headers);
        Assert.assertNotNull((Object)this.record.headers());
        Assert.assertSame((Object)headers, (Object)this.record.headers());
        Assert.assertFalse((boolean)this.record.headers().isEmpty());
    }

    @Test
    public void shouldCreateSinkRecordWithEmtpyHeaders() {
        Assert.assertEquals(SOURCE_PARTITION, (Object)this.record.sourcePartition());
        Assert.assertEquals(SOURCE_OFFSET, (Object)this.record.sourceOffset());
        Assert.assertEquals((Object)TOPIC_NAME, (Object)this.record.topic());
        Assert.assertEquals((Object)PARTITION_NUMBER, (Object)this.record.kafkaPartition());
        Assert.assertEquals((Object)Schema.STRING_SCHEMA, (Object)this.record.keySchema());
        Assert.assertEquals((Object)"key", (Object)this.record.key());
        Assert.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)this.record.valueSchema());
        Assert.assertEquals((Object)false, (Object)this.record.value());
        Assert.assertEquals((Object)KAFKA_TIMESTAMP, (Object)this.record.timestamp());
        Assert.assertNotNull((Object)this.record.headers());
        Assert.assertTrue((boolean)this.record.headers().isEmpty());
    }

    @Test
    public void shouldDuplicateRecordAndCloneHeaders() {
        SourceRecord duplicate = this.record.newRecord(TOPIC_NAME, PARTITION_NUMBER, Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, KAFKA_TIMESTAMP);
        Assert.assertEquals(SOURCE_PARTITION, (Object)duplicate.sourcePartition());
        Assert.assertEquals(SOURCE_OFFSET, (Object)duplicate.sourceOffset());
        Assert.assertEquals((Object)TOPIC_NAME, (Object)duplicate.topic());
        Assert.assertEquals((Object)PARTITION_NUMBER, (Object)duplicate.kafkaPartition());
        Assert.assertEquals((Object)Schema.STRING_SCHEMA, (Object)duplicate.keySchema());
        Assert.assertEquals((Object)"key", (Object)duplicate.key());
        Assert.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)duplicate.valueSchema());
        Assert.assertEquals((Object)false, (Object)duplicate.value());
        Assert.assertEquals((Object)KAFKA_TIMESTAMP, (Object)duplicate.timestamp());
        Assert.assertNotNull((Object)duplicate.headers());
        Assert.assertTrue((boolean)duplicate.headers().isEmpty());
        Assert.assertNotSame((Object)this.record.headers(), (Object)duplicate.headers());
        Assert.assertEquals((Object)this.record.headers(), (Object)duplicate.headers());
    }

    @Test
    public void shouldDuplicateRecordUsingNewHeaders() {
        Headers newHeaders = new ConnectHeaders().addString("h3", "hv3");
        SourceRecord duplicate = this.record.newRecord(TOPIC_NAME, PARTITION_NUMBER, Schema.STRING_SCHEMA, (Object)"key", Schema.BOOLEAN_SCHEMA, (Object)false, KAFKA_TIMESTAMP, (Iterable)newHeaders);
        Assert.assertEquals(SOURCE_PARTITION, (Object)duplicate.sourcePartition());
        Assert.assertEquals(SOURCE_OFFSET, (Object)duplicate.sourceOffset());
        Assert.assertEquals((Object)TOPIC_NAME, (Object)duplicate.topic());
        Assert.assertEquals((Object)PARTITION_NUMBER, (Object)duplicate.kafkaPartition());
        Assert.assertEquals((Object)Schema.STRING_SCHEMA, (Object)duplicate.keySchema());
        Assert.assertEquals((Object)"key", (Object)duplicate.key());
        Assert.assertEquals((Object)Schema.BOOLEAN_SCHEMA, (Object)duplicate.valueSchema());
        Assert.assertEquals((Object)false, (Object)duplicate.value());
        Assert.assertEquals((Object)KAFKA_TIMESTAMP, (Object)duplicate.timestamp());
        Assert.assertNotNull((Object)duplicate.headers());
        Assert.assertEquals((Object)newHeaders, (Object)duplicate.headers());
        Assert.assertSame((Object)newHeaders, (Object)duplicate.headers());
        Assert.assertNotSame((Object)this.record.headers(), (Object)duplicate.headers());
        Assert.assertNotEquals((Object)this.record.headers(), (Object)duplicate.headers());
    }

    @Test
    public void shouldModifyRecordHeader() {
        Assert.assertTrue((boolean)this.record.headers().isEmpty());
        this.record.headers().addInt("intHeader", 100);
        Assert.assertEquals((long)1L, (long)this.record.headers().size());
        Header header = this.record.headers().lastWithName("intHeader");
        Assert.assertEquals((long)100L, (long)Values.convertToInteger((Schema)header.schema(), (Object)header.value()).intValue());
    }
}

