/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;
import org.apache.kafka.connect.errors.DataException;
import org.junit.Assert;
import org.junit.Test;

public class ValuesTest {
    private static final Map<String, String> STRING_MAP = new LinkedHashMap<String, String>();
    private static final Schema STRING_MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.STRING_SCHEMA).schema();
    private static final Map<String, Short> STRING_SHORT_MAP = new LinkedHashMap<String, Short>();
    private static final Schema STRING_SHORT_MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT16_SCHEMA).schema();
    private static final Map<String, Integer> STRING_INT_MAP = new LinkedHashMap<String, Integer>();
    private static final Schema STRING_INT_MAP_SCHEMA = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)Schema.INT32_SCHEMA).schema();
    private static final List<Integer> INT_LIST = new ArrayList<Integer>();
    private static final Schema INT_LIST_SCHEMA = SchemaBuilder.array((Schema)Schema.INT32_SCHEMA).schema();
    private static final List<String> STRING_LIST = new ArrayList<String>();
    private static final Schema STRING_LIST_SCHEMA = SchemaBuilder.array((Schema)Schema.STRING_SCHEMA).schema();

    @Test
    public void shouldEscapeStringsWithEmbeddedQuotesAndBackslashes() {
        String original = "three\"blind\\\"mice";
        String expected = "three\\\"blind\\\\\\\"mice";
        Assert.assertEquals((Object)expected, (Object)Values.escape((String)original));
    }

    @Test
    public void shouldConvertNullValue() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA, null);
        this.assertRoundTrip(Schema.OPTIONAL_STRING_SCHEMA, Schema.STRING_SCHEMA, null);
    }

    @Test
    public void shouldConvertSimpleString() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, "simple");
    }

    @Test
    public void shouldConvertEmptyString() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, "");
    }

    @Test
    public void shouldConvertStringWithQuotesAndOtherDelimiterCharacters() {
        this.assertRoundTrip(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA, "three\"blind\\\"mice");
        this.assertRoundTrip(Schema.STRING_SCHEMA, Schema.STRING_SCHEMA, "string with delimiters: <>?,./\\=+-!@#$%^&*(){}[]|;':");
    }

    @Test
    public void shouldConvertMapWithStringKeys() {
        this.assertRoundTrip(STRING_MAP_SCHEMA, STRING_MAP_SCHEMA, STRING_MAP);
    }

    @Test
    public void shouldParseStringOfMapWithStringValuesWithoutWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_MAP_SCHEMA, "{\"foo\":\"123\",\"bar\":\"baz\"}");
        Assert.assertEquals((Object)STRING_MAP_SCHEMA, (Object)result.schema());
        Assert.assertEquals(STRING_MAP, (Object)result.value());
    }

    @Test
    public void shouldParseStringOfMapWithStringValuesWithWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_MAP_SCHEMA, "{ \"foo\" : \"123\", \n\"bar\" : \"baz\" } ");
        Assert.assertEquals((Object)STRING_MAP_SCHEMA, (Object)result.schema());
        Assert.assertEquals(STRING_MAP, (Object)result.value());
    }

    @Test
    public void shouldConvertMapWithStringKeysAndShortValues() {
        this.assertRoundTrip(STRING_SHORT_MAP_SCHEMA, STRING_SHORT_MAP_SCHEMA, STRING_SHORT_MAP);
    }

    @Test
    public void shouldParseStringOfMapWithShortValuesWithoutWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_SHORT_MAP_SCHEMA, "{\"foo\":12345,\"bar\":0,\"baz\":-4321}");
        Assert.assertEquals((Object)STRING_SHORT_MAP_SCHEMA, (Object)result.schema());
        Assert.assertEquals(STRING_SHORT_MAP, (Object)result.value());
    }

    @Test
    public void shouldParseStringOfMapWithShortValuesWithWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_SHORT_MAP_SCHEMA, " { \"foo\" :  12345 , \"bar\" : 0,  \"baz\" : -4321 }  ");
        Assert.assertEquals((Object)STRING_SHORT_MAP_SCHEMA, (Object)result.schema());
        Assert.assertEquals(STRING_SHORT_MAP, (Object)result.value());
    }

    @Test
    public void shouldConvertMapWithStringKeysAndIntegerValues() {
        this.assertRoundTrip(STRING_INT_MAP_SCHEMA, STRING_INT_MAP_SCHEMA, STRING_INT_MAP);
    }

    @Test
    public void shouldParseStringOfMapWithIntValuesWithoutWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_INT_MAP_SCHEMA, "{\"foo\":1234567890,\"bar\":0,\"baz\":-987654321}");
        Assert.assertEquals((Object)STRING_INT_MAP_SCHEMA, (Object)result.schema());
        Assert.assertEquals(STRING_INT_MAP, (Object)result.value());
    }

    @Test
    public void shouldParseStringOfMapWithIntValuesWithWhitespaceAsMap() {
        SchemaAndValue result = this.roundTrip(STRING_INT_MAP_SCHEMA, " { \"foo\" :  1234567890 , \"bar\" : 0,  \"baz\" : -987654321 }  ");
        Assert.assertEquals((Object)STRING_INT_MAP_SCHEMA, (Object)result.schema());
        Assert.assertEquals(STRING_INT_MAP, (Object)result.value());
    }

    @Test
    public void shouldConvertListWithStringValues() {
        this.assertRoundTrip(STRING_LIST_SCHEMA, STRING_LIST_SCHEMA, STRING_LIST);
    }

    @Test
    public void shouldConvertListWithIntegerValues() {
        this.assertRoundTrip(INT_LIST_SCHEMA, INT_LIST_SCHEMA, INT_LIST);
    }

    @Test
    public void shouldConvertStringOfListWithOnlyNumericElementTypesIntoListOfLargestNumericType() {
        int thirdValue = 32768;
        List list = Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)("[1, 2, " + thirdValue + "]"));
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Number)list.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Number)list.get(1)).intValue());
        Assert.assertEquals((long)thirdValue, (long)((Number)list.get(2)).intValue());
    }

    @Test
    public void shouldConvertStringOfListWithMixedElementTypesIntoListWithDifferentElementTypes() {
        String str = "[1, 2, \"three\"]";
        List list = Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)str);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Number)list.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Number)list.get(1)).intValue());
        Assert.assertEquals((Object)"three", list.get(2));
    }

    @Test
    public void shouldParseStringListWithMultipleElementTypesAndReturnListWithNoSchema() {
        String str = "[1, 2, 3, \"four\"]";
        SchemaAndValue result = Values.parseString((String)str);
        Assert.assertNull((Object)result.schema());
        List list = (List)result.value();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Number)list.get(0)).intValue());
        Assert.assertEquals((long)2L, (long)((Number)list.get(1)).intValue());
        Assert.assertEquals((long)3L, (long)((Number)list.get(2)).intValue());
        Assert.assertEquals((Object)"four", list.get(3));
    }

    @Test
    public void shouldParseStringListWithExtraDelimitersAndReturnString() {
        String str = "[1, 2, 3,,,]";
        SchemaAndValue result = Values.parseString((String)str);
        Assert.assertEquals((Object)Schema.Type.STRING, (Object)result.schema().type());
        Assert.assertEquals((Object)str, (Object)result.value());
    }

    @Test(expected=DataException.class)
    public void shouldFailToConvertToListFromStringWithExtraDelimiters() {
        Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)"[1, 2, 3,,,]");
    }

    @Test(expected=DataException.class)
    public void shouldFailToConvertToListFromStringWithNonCommonElementTypeAndBlankElement() {
        Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)"[1, 2, 3, \"four\",,,]");
    }

    @Test(expected=DataException.class)
    public void shouldFailToParseStringOfMapWithIntValuesWithBlankEntry() {
        Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)" { \"foo\" :  1234567890 ,, \"bar\" : 0,  \"baz\" : -987654321 }  ");
    }

    @Test(expected=DataException.class)
    public void shouldFailToParseStringOfMalformedMap() {
        Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)" { \"foo\" :  1234567890 , \"a\", \"bar\" : 0,  \"baz\" : -987654321 }  ");
    }

    @Test(expected=DataException.class)
    public void shouldFailToParseStringOfMapWithIntValuesWithOnlyBlankEntries() {
        Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)" { ,,  , , }  ");
    }

    @Test(expected=DataException.class)
    public void shouldFailToParseStringOfMapWithIntValuesWithBlankEntries() {
        Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)" { \"foo\" :  \"1234567890\" ,, \"bar\" : \"0\",  \"baz\" : \"boz\" }  ");
    }

    @Test(expected=DataException.class)
    public void shouldFailToParseStringOfEmptyMap() {
        Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)" { }  ");
    }

    @Test
    public void shouldParseStringsWithoutDelimiters() {
        this.assertParsed("  ");
        this.assertParsed("simple");
        this.assertParsed("simple string");
        this.assertParsed("simple \n\t\bstring");
        this.assertParsed("'simple' string");
        this.assertParsed("si\\mple");
        this.assertParsed("si\\\\mple");
    }

    @Test
    public void shouldParseStringsWithEscapedDelimiters() {
        this.assertParsed("si\\\"mple");
        this.assertParsed("si\\{mple");
        this.assertParsed("si\\}mple");
        this.assertParsed("si\\]mple");
        this.assertParsed("si\\[mple");
        this.assertParsed("si\\:mple");
        this.assertParsed("si\\,mple");
    }

    @Test
    public void shouldParseStringsWithSingleDelimiter() {
        this.assertParsed("a{b", "a", "{", "b");
        this.assertParsed("a}b", "a", "}", "b");
        this.assertParsed("a[b", "a", "[", "b");
        this.assertParsed("a]b", "a", "]", "b");
        this.assertParsed("a:b", "a", ":", "b");
        this.assertParsed("a,b", "a", ",", "b");
        this.assertParsed("a\"b", "a", "\"", "b");
        this.assertParsed("{b", "{", "b");
        this.assertParsed("}b", "}", "b");
        this.assertParsed("[b", "[", "b");
        this.assertParsed("]b", "]", "b");
        this.assertParsed(":b", ":", "b");
        this.assertParsed(",b", ",", "b");
        this.assertParsed("\"b", "\"", "b");
        this.assertParsed("{", "{");
        this.assertParsed("}", "}");
        this.assertParsed("[", "[");
        this.assertParsed("]", "]");
        this.assertParsed(":", ":");
        this.assertParsed(",", ",");
        this.assertParsed("\"", "\"");
    }

    @Test
    public void shouldParseStringsWithMultipleDelimiters() {
        this.assertParsed("\"simple\" string", "\"", "simple", "\"", " string");
        this.assertParsed("a{bc}d", "a", "{", "bc", "}", "d");
        this.assertParsed("a { b c } d", "a ", "{", " b c ", "}", " d");
        this.assertParsed("a { b c } d", "a ", "{", " b c ", "}", " d");
    }

    @Test
    public void canConsume() {
    }

    protected void assertParsed(String input) {
        this.assertParsed(input, input);
    }

    protected void assertParsed(String input, String ... expectedTokens) {
        Values.Parser parser = new Values.Parser(input);
        if (!parser.hasNext()) {
            Assert.assertEquals((long)1L, (long)expectedTokens.length);
            Assert.assertTrue((boolean)expectedTokens[0].isEmpty());
            return;
        }
        for (String expectedToken : expectedTokens) {
            Assert.assertTrue((boolean)parser.hasNext());
            int position = parser.mark();
            Assert.assertEquals((Object)expectedToken, (Object)parser.next());
            Assert.assertEquals((long)(position + expectedToken.length()), (long)parser.position());
            Assert.assertEquals((Object)expectedToken, (Object)parser.previous());
            parser.rewindTo(position);
            Assert.assertEquals((long)position, (long)parser.position());
            Assert.assertEquals((Object)expectedToken, (Object)parser.next());
            int newPosition = parser.mark();
            Assert.assertEquals((long)(position + expectedToken.length()), (long)newPosition);
            Assert.assertEquals((Object)expectedToken, (Object)parser.previous());
        }
        Assert.assertFalse((boolean)parser.hasNext());
        parser.rewindTo(0);
        this.assertConsumable(parser, expectedTokens);
        parser = new Values.Parser(input);
        this.assertConsumable(parser, expectedTokens);
    }

    protected void assertConsumable(Values.Parser parser, String ... expectedTokens) {
        for (String expectedToken : expectedTokens) {
            if (expectedToken.trim().isEmpty()) continue;
            int position = parser.mark();
            Assert.assertTrue((boolean)parser.canConsume(expectedToken.trim()));
            parser.rewindTo(position);
            Assert.assertTrue((boolean)parser.canConsume(expectedToken.trim(), true));
            parser.rewindTo(position);
            Assert.assertTrue((boolean)parser.canConsume(expectedToken, false));
        }
    }

    protected SchemaAndValue roundTrip(Schema desiredSchema, String currentValue) {
        return this.roundTrip(desiredSchema, new SchemaAndValue(Schema.STRING_SCHEMA, (Object)currentValue));
    }

    protected SchemaAndValue roundTrip(Schema desiredSchema, SchemaAndValue input) {
        String serialized = Values.convertToString((Schema)input.schema(), (Object)input.value());
        if (input != null && input.value() != null) {
            Assert.assertNotNull((Object)serialized);
        }
        if (desiredSchema == null) {
            desiredSchema = Values.inferSchema((Object)input);
            Assert.assertNotNull((Object)desiredSchema);
        }
        Object newValue = null;
        Schema newSchema = null;
        switch (desiredSchema.type()) {
            case STRING: {
                newValue = Values.convertToString((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case INT8: {
                newValue = Values.convertToByte((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case INT16: {
                newValue = Values.convertToShort((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case INT32: {
                newValue = Values.convertToInteger((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case INT64: {
                newValue = Values.convertToLong((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case FLOAT32: {
                newValue = Values.convertToFloat((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case FLOAT64: {
                newValue = Values.convertToDouble((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case BOOLEAN: {
                newValue = Values.convertToBoolean((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case ARRAY: {
                newValue = Values.convertToList((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case MAP: {
                newValue = Values.convertToMap((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case STRUCT: {
                newValue = Values.convertToStruct((Schema)Schema.STRING_SCHEMA, (Object)serialized);
                break;
            }
            case BYTES: {
                Assert.fail((String)"unexpected schema type");
            }
        }
        newSchema = Values.inferSchema(newValue);
        return new SchemaAndValue(newSchema, newValue);
    }

    protected void assertRoundTrip(Schema schema, String value) {
        this.assertRoundTrip(schema, Schema.STRING_SCHEMA, value);
    }

    protected void assertRoundTrip(Schema schema, Schema currentSchema, Object value) {
        SchemaAndValue result = this.roundTrip(schema, new SchemaAndValue(currentSchema, value));
        if (value == null) {
            Assert.assertNull((Object)result.schema());
            Assert.assertNull((Object)result.value());
        } else {
            Assert.assertEquals((Object)value, (Object)result.value());
            Assert.assertEquals((Object)schema, (Object)result.schema());
            SchemaAndValue result2 = this.roundTrip(result.schema(), result);
            Assert.assertEquals((Object)schema, (Object)result2.schema());
            Assert.assertEquals((Object)value, (Object)result2.value());
            Assert.assertEquals((Object)result, (Object)result2);
        }
    }

    static {
        STRING_MAP.put("foo", "123");
        STRING_MAP.put("bar", "baz");
        STRING_SHORT_MAP.put("foo", (short)12345);
        STRING_SHORT_MAP.put("bar", (short)0);
        STRING_SHORT_MAP.put("baz", (short)-4321);
        STRING_INT_MAP.put("foo", 1234567890);
        STRING_INT_MAP.put("bar", 0);
        STRING_INT_MAP.put("baz", -987654321);
        STRING_LIST.add("foo");
        STRING_LIST.add("bar");
        INT_LIST.add(1234567890);
        INT_LIST.add(-987654321);
    }
}

