/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.response;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.ReasonPhraseCatalog;
import org.apache.http.StatusLine;
import org.apache.http.params.HttpParams;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.BasicStatusLine;
import org.apache.juneau.http.HttpEntities;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;

@BeanIgnore
@FluentSetters(ignore={"setUnmodifiable"})
public class BasicHttpException
extends BasicRuntimeException
implements HttpResponse {
    private static final long serialVersionUID = 1L;
    HeaderList headers = HeaderList.create();
    BasicStatusLine statusLine = new BasicStatusLine();
    HttpEntity content;

    public BasicHttpException(int statusCode, Throwable cause, String msg, Object ... args) {
        super(cause, msg, args);
        this.setStatusCode(statusCode);
        this.setContent(StringUtils.format((String)msg, (Object[])args));
    }

    public BasicHttpException(int statusCode) {
        super((Throwable)null);
        this.setStatusCode(statusCode);
    }

    public BasicHttpException(int statusCode, String msg, Object ... args) {
        super(msg, args);
        this.setStatusCode(statusCode);
    }

    public BasicHttpException(int statusCode, Throwable causedBy) {
        super(causedBy);
        this.setStatusCode(statusCode);
    }

    public BasicHttpException() {
        super((Throwable)null);
    }

    public BasicHttpException(HttpResponse response) {
        super((Throwable)null);
        Header h = response.getLastHeader("Thrown");
        if (h != null) {
            this.setMessage(HttpHeaders.thrown(h.getValue()).asParts().get().get(0).getMessage(), new Object[0]);
        }
        this.setHeaders(response.getAllHeaders());
        this.setContent(response.getEntity());
        this.setStatusCode(response.getStatusLine().getStatusCode());
    }

    protected BasicHttpException(BasicHttpException copyFrom) {
        this(0, copyFrom.getCause(), copyFrom.getMessage(), new Object[0]);
        this.setStatusLine(copyFrom.statusLine.copy());
    }

    @FluentSetter
    public BasicHttpException setUnmodifiable() {
        super.setUnmodifiable();
        this.statusLine.setUnmodifiable();
        return this;
    }

    @FluentSetter
    public BasicHttpException setStatusLine(BasicStatusLine value) {
        this.assertModifiable();
        this.statusLine = value.copy();
        return this;
    }

    @FluentSetter
    public BasicHttpException setStatusCode2(int code) throws IllegalStateException {
        this.setStatusCode(code);
        return this;
    }

    @FluentSetter
    public BasicHttpException setProtocolVersion(ProtocolVersion value) {
        this.statusLine.setProtocolVersion(value);
        return this;
    }

    @FluentSetter
    public BasicHttpException setReasonPhrase2(String value) {
        this.statusLine.setReasonPhrase(value);
        return this;
    }

    @FluentSetter
    public BasicHttpException setReasonPhraseCatalog(ReasonPhraseCatalog value) {
        this.statusLine.setReasonPhraseCatalog(value);
        return this;
    }

    @FluentSetter
    public BasicHttpException setLocale2(Locale value) {
        this.statusLine.setLocale(value);
        return this;
    }

    public HeaderList getHeaders() {
        this.assertModifiable();
        return this.headers;
    }

    @FluentSetter
    public BasicHttpException setHeaders(HeaderList value) {
        this.assertModifiable();
        this.headers = value.copy();
        return this;
    }

    @FluentSetter
    public BasicHttpException setHeader2(String name, Object value) {
        this.headers.set(name, value);
        return this;
    }

    @FluentSetter
    public BasicHttpException setHeaders2(Header ... values) {
        this.headers.set(values);
        return this;
    }

    public BasicHttpException setHeaders(List<Header> values) {
        this.headers.set(values);
        return this;
    }

    public BasicHttpException setContent(String value) {
        this.setContent(HttpEntities.stringEntity(value));
        return this;
    }

    public BasicHttpException setContent(HttpEntity value) {
        this.assertModifiable();
        this.content = value;
        return this;
    }

    protected void assertStatusCode(HttpResponse response) throws AssertionError {
        ArgUtils.assertArgNotNull((String)"response", (Object)response);
        int expected = this.getStatusLine().getStatusCode();
        int actual = response.getStatusLine().getStatusCode();
        Assertions.assertInteger((Integer)actual).setMsg("Unexpected status code.  Expected:[{0}], Actual:[{1}]", new Object[]{expected, actual}).is((Object)expected);
    }

    public Throwable getRootCause() {
        for (Object t = this; t != null; t = ((Throwable)t).getCause()) {
            if (t instanceof BasicHttpException || t instanceof InvocationTargetException) continue;
            return t;
        }
        return null;
    }

    public String getFullStackMessage(boolean scrubForXssVulnerabilities) {
        String msg = this.getMessage();
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            if (scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            sb.append(msg);
        }
        for (Throwable e = this.getCause(); e != null; e = e.getCause()) {
            msg = e.getMessage();
            if (msg != null && scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            String cls = e.getClass().getSimpleName();
            if (msg == null) {
                sb.append(StringUtils.format((String)"\nCaused by ({0})", (Object[])new Object[]{cls}));
                continue;
            }
            sb.append(StringUtils.format((String)"\nCaused by ({0}): {1}", (Object[])new Object[]{cls, msg}));
        }
        return sb.toString();
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null && this.getCause() != null) {
            m = this.getCause().getMessage();
        }
        if (m == null) {
            m = this.statusLine.getReasonPhrase();
        }
        return m;
    }

    public int hashCode() {
        int i = 0;
        for (Object t = this; t != null; t = ((Throwable)t).getCause()) {
            for (StackTraceElement e : ((Throwable)t).getStackTrace()) {
                i ^= e.hashCode();
            }
        }
        return i;
    }

    public String toString() {
        return StringUtils.emptyIfNull((String)this.getLocalizedMessage());
    }

    public ProtocolVersion getProtocolVersion() {
        return this.statusLine.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        return this.headers.contains(name);
    }

    public Header[] getHeaders(String name) {
        return this.headers.getAll(name);
    }

    public Header getFirstHeader(String name) {
        return this.headers.getFirst(name).orElse(null);
    }

    public Header getLastHeader(String name) {
        return this.headers.getLast(name).orElse(null);
    }

    public Header[] getAllHeaders() {
        return this.headers.getAll();
    }

    public void addHeader(Header value) {
        this.headers.append(value);
    }

    public void addHeader(String name, String value) {
        this.headers.append(name, value);
    }

    public void setHeader(Header value) {
        this.headers.set(value);
    }

    public void setHeader(String name, String value) {
        this.headers.set(name, value);
    }

    public void setHeaders(Header[] values) {
        this.headers.removeAll().append(values);
    }

    public void removeHeader(Header value) {
        this.headers.remove(value);
    }

    public void removeHeaders(String name) {
        this.headers.remove(name);
    }

    public HeaderIterator headerIterator() {
        return this.headers.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.headers.headerIterator(name);
    }

    public HttpParams getParams() {
        return null;
    }

    public void setParams(HttpParams params) {
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public void setStatusLine(StatusLine value) {
        this.setStatusLine(value.getProtocolVersion(), value.getStatusCode(), value.getReasonPhrase());
    }

    public void setStatusLine(ProtocolVersion ver, int code) {
        this.statusLine.setProtocolVersion(ver).setStatusCode(code);
    }

    public void setStatusLine(ProtocolVersion ver, int code, String reason) {
        this.statusLine.setProtocolVersion(ver).setReasonPhrase(reason).setStatusCode(code);
    }

    public void setStatusCode(int code) throws IllegalStateException {
        this.statusLine.setStatusCode(code);
    }

    public void setReasonPhrase(String reason) throws IllegalStateException {
        this.statusLine.setReasonPhrase(reason);
    }

    public HttpEntity getEntity() {
        if (this.content == null) {
            this.content = HttpEntities.stringEntity(this.getMessage());
        }
        return this.content;
    }

    public void setEntity(HttpEntity entity) {
        this.assertModifiable();
        this.content = entity;
    }

    public Locale getLocale() {
        return this.statusLine.getLocale();
    }

    public void setLocale(Locale loc) {
        this.statusLine.setLocale(loc);
    }

    public BasicHttpException setMessage(String message, Object ... args) {
        super.setMessage(message, args);
        return this;
    }
}

