/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.entity.StreamEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.resource.HttpResource;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;

@BeanIgnore
@FluentSetters
public class BasicResource
implements HttpResource {
    BasicHttpEntity entity;
    HeaderList headers = HeaderList.create();
    boolean unmodifiable;

    public BasicResource(BasicHttpEntity entity) {
        this.entity = entity;
    }

    public BasicResource(BasicResource copyFrom) {
        this.entity = copyFrom.entity.copy();
        this.headers = copyFrom.headers.copy();
    }

    public BasicResource(HttpResponse response) throws IOException {
        this(new StreamEntity());
        this.copyFrom(response);
    }

    public BasicResource copy() {
        return new BasicResource(this);
    }

    public BasicResource copyFrom(HttpResponse response) throws IOException {
        this.addHeaders(response.getAllHeaders());
        this.setContent(response.getEntity().getContent());
        return this;
    }

    @FluentSetter
    public BasicResource setUnmodifiable() {
        this.unmodifiable = true;
        this.entity.setUnmodifiable();
        this.headers.setUnmodifiable();
        return this;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    protected final void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("Bean is read-only");
        }
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    @FluentSetter
    public BasicResource setContent(Object value) {
        this.entity.setContent(value);
        return this;
    }

    @FluentSetter
    public BasicResource setContent(Supplier<?> value) {
        this.entity.setContent(value);
        return this;
    }

    @FluentSetter
    public BasicResource setContentType(String value) {
        this.entity.setContentType(value);
        return this;
    }

    @FluentSetter
    public BasicResource setContentType(ContentType value) {
        this.entity.setContentType(value);
        return this;
    }

    @FluentSetter
    public BasicResource setContentLength(long value) {
        this.entity.setContentLength(value);
        return this;
    }

    @FluentSetter
    public BasicResource setContentEncoding(String value) {
        this.entity.setContentEncoding(value);
        return this;
    }

    @FluentSetter
    public BasicResource setContentEncoding(ContentEncoding value) {
        this.entity.setContentEncoding(value);
        return this;
    }

    @FluentSetter
    public BasicResource setChunked() {
        this.entity.setChunked();
        return this;
    }

    @FluentSetter
    public BasicResource setChunked(boolean value) {
        this.entity.setChunked(value);
        return this;
    }

    @FluentSetter
    public BasicResource setCached() throws IOException {
        this.entity.setCached();
        return this;
    }

    public BasicResource setHeader(String name, String value) {
        if (name != null && value != null) {
            this.headers.set(name, value);
        }
        return this;
    }

    public BasicResource addHeader(String name, String value) {
        if (name != null && value != null) {
            this.headers.append(name, value);
        }
        return this;
    }

    @FluentSetter
    public BasicResource setHeaders(HeaderList value) {
        this.headers = value.copy();
        return this;
    }

    public BasicResource setHeaders(Header ... values) {
        for (Header h : values) {
            if (h == null) continue;
            String n = h.getName();
            String v = h.getValue();
            if (!StringUtils.isNotEmpty((String)n)) continue;
            if (n.equalsIgnoreCase("content-type")) {
                this.setContentType(v);
                continue;
            }
            if (n.equalsIgnoreCase("content-encoding")) {
                this.setContentEncoding(v);
                continue;
            }
            if (n.equalsIgnoreCase("content-length")) {
                this.setContentLength(Long.parseLong(v));
                continue;
            }
            this.headers.set(h);
        }
        return this;
    }

    public BasicResource addHeaders(Header ... values) {
        for (Header h : values) {
            if (h == null) continue;
            String n = h.getName();
            String v = h.getValue();
            if (!StringUtils.isNotEmpty((String)n)) continue;
            if (n.equalsIgnoreCase("content-type")) {
                this.setContentType(v);
                continue;
            }
            if (n.equalsIgnoreCase("content-encoding")) {
                this.setContentEncoding(v);
                continue;
            }
            if (n.equalsIgnoreCase("content-length")) {
                this.setContentLength(Long.parseLong(v));
                continue;
            }
            this.headers.append(h);
        }
        return this;
    }

    public String asString() throws IOException {
        return this.entity.asString();
    }

    public byte[] asBytes() throws IOException {
        return this.entity.asBytes();
    }

    public FluentStringAssertion<BasicResource> assertString() throws IOException {
        return new FluentStringAssertion(this.asString(), (Object)this);
    }

    public FluentByteArrayAssertion<BasicResource> assertBytes() throws IOException {
        return new FluentByteArrayAssertion(this.asBytes(), (Object)this);
    }

    public long getContentLength() {
        return this.entity.getContentLength();
    }

    public boolean isRepeatable() {
        return this.entity.isRepeatable();
    }

    public boolean isChunked() {
        return this.entity.isChunked();
    }

    public Header getContentType() {
        return this.entity.getContentType();
    }

    public Header getContentEncoding() {
        return this.entity.getContentEncoding();
    }

    public boolean isStreaming() {
        return this.entity.isStreaming();
    }

    public void consumeContent() throws IOException {
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.entity.getContent();
    }

    public void writeTo(OutputStream outStream) throws IOException {
        this.entity.writeTo(outStream);
    }

    @Override
    public HeaderList getHeaders() {
        return this.headers;
    }
}

