/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.http.util.CharArrayBuffer;
import org.apache.juneau.collections.ControlledArrayList;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.http.part.BasicPartIterator;
import org.apache.juneau.http.part.BasicStringPart;
import org.apache.juneau.http.part.PartBeanMeta;
import org.apache.juneau.http.part.PartIterator;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.svl.VarResolver;

@FluentSetters
public class PartList
extends ControlledArrayList<NameValuePair> {
    private static final long serialVersionUID = 1L;
    private VarResolver varResolver;
    boolean caseInsensitive;

    public static PartList create() {
        return new PartList();
    }

    public static PartList of(List<NameValuePair> parts) {
        return new PartList().append(parts);
    }

    public static PartList of(NameValuePair ... parts) {
        return new PartList().append(parts);
    }

    public static PartList ofPairs(String ... pairs) {
        PartList x = new PartList();
        if (pairs == null) {
            pairs = new String[]{};
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of parameters passed into PartList.ofPairs()");
        }
        for (int i = 0; i < pairs.length; i += 2) {
            x.add(BasicPart.of(pairs[i], pairs[i + 1]));
        }
        return x;
    }

    public PartList() {
        super(false);
    }

    protected PartList(PartList copyFrom) {
        super(false, (List)((Object)copyFrom));
        this.caseInsensitive = copyFrom.caseInsensitive;
    }

    public PartList copy() {
        return new PartList(this);
    }

    public PartList setDefault(List<NameValuePair> parts) {
        if (parts != null) {
            parts.stream().filter(x -> x != null && !this.contains(x.getName())).forEach(this::set);
        }
        return this;
    }

    public PartList setDefault(NameValuePair ... parts) {
        if (parts != null) {
            this.setDefault(Arrays.asList(parts));
        }
        return this;
    }

    public PartList setDefault(String name, Object value) {
        return this.setDefault(this.createPart(name, value));
    }

    public PartList setDefault(String name, Supplier<?> value) {
        return this.setDefault(this.createPart(name, value));
    }

    public PartList resolving() {
        return this.resolving(VarResolver.DEFAULT);
    }

    public PartList resolving(VarResolver varResolver) {
        this.assertModifiable();
        this.varResolver = varResolver;
        return this;
    }

    public PartList caseInsensitive(boolean value) {
        this.assertModifiable();
        this.caseInsensitive = value;
        return this;
    }

    @FluentSetter
    public PartList append(NameValuePair value) {
        if (value != null) {
            this.add(value);
        }
        return this;
    }

    public PartList append(String name, Object value) {
        return this.append(this.createPart(name, value));
    }

    public PartList append(String name, Supplier<?> value) {
        return this.append(this.createPart(name, value));
    }

    @FluentSetter
    public PartList append(NameValuePair ... values) {
        if (values != null) {
            for (NameValuePair value : values) {
                this.append(value);
            }
        }
        return this;
    }

    @FluentSetter
    public PartList append(List<NameValuePair> values) {
        if (values != null) {
            values.forEach(this::append);
        }
        return this;
    }

    @FluentSetter
    public PartList prepend(NameValuePair value) {
        if (value != null) {
            this.add(0, value);
        }
        return this;
    }

    public PartList prepend(String name, Object value) {
        return this.prepend(this.createPart(name, value));
    }

    public PartList prepend(String name, Supplier<?> value) {
        return this.prepend(this.createPart(name, value));
    }

    @FluentSetter
    public PartList prepend(NameValuePair ... values) {
        if (values != null) {
            this.prepend(CollectionUtils.alist((Object[])values));
        }
        return this;
    }

    @FluentSetter
    public PartList prepend(List<NameValuePair> values) {
        if (values != null) {
            this.addAll(0, values);
        }
        return this;
    }

    @FluentSetter
    public PartList remove(NameValuePair value) {
        if (value != null) {
            this.removeIf(x -> this.eq(x.getName(), value.getName()) && this.eq(x.getValue(), value.getValue()));
        }
        return this;
    }

    @FluentSetter
    public PartList remove(NameValuePair ... values) {
        for (NameValuePair value : values) {
            this.remove(value);
        }
        return this;
    }

    @FluentSetter
    public PartList remove(List<NameValuePair> values) {
        if (values != null) {
            values.forEach(this::remove);
        }
        return this;
    }

    @FluentSetter
    public PartList remove(String name) {
        this.removeIf(x -> this.eq(x.getName(), name));
        return this;
    }

    @FluentSetter
    public PartList remove(String ... names) {
        if (names != null) {
            for (String name : names) {
                this.remove(name);
            }
        }
        return this;
    }

    @FluentSetter
    public PartList set(NameValuePair value) {
        if (value != null) {
            boolean replaced = false;
            int j = this.size();
            for (int i = 0; i < j; ++i) {
                NameValuePair x = (NameValuePair)this.get(i);
                if (!this.eq(x.getName(), value.getName())) continue;
                if (replaced) {
                    this.remove(i);
                    --j;
                    continue;
                }
                this.set(i, value);
                replaced = true;
            }
            if (!replaced) {
                this.add(value);
            }
        }
        return this;
    }

    @FluentSetter
    public PartList set(NameValuePair ... values) {
        if (values != null) {
            this.set(CollectionUtils.alist((Object[])values));
        }
        return this;
    }

    public PartList set(String name, Object value) {
        return this.set(this.createPart(name, value));
    }

    public PartList set(String name, Supplier<?> value) {
        return this.set(this.createPart(name, value));
    }

    @FluentSetter
    public PartList set(List<NameValuePair> values) {
        if (values != null) {
            for (NameValuePair h : values) {
                if (h == null) continue;
                int j2 = this.size();
                for (int i2 = 0; i2 < j2; ++i2) {
                    NameValuePair x = (NameValuePair)this.get(i2);
                    if (!this.eq(x.getName(), h.getName())) continue;
                    this.remove(i2);
                    --j2;
                }
            }
            for (NameValuePair x : values) {
                if (x == null) continue;
                this.add(x);
            }
        }
        return this;
    }

    public Optional<NameValuePair> getFirst(String name) {
        for (int i = 0; i < this.size(); ++i) {
            NameValuePair x = (NameValuePair)this.get(i);
            if (!this.eq(x.getName(), name)) continue;
            return CollectionUtils.optional((Object)x);
        }
        return CollectionUtils.empty();
    }

    public Optional<NameValuePair> getLast(String name) {
        for (int i = this.size() - 1; i >= 0; --i) {
            NameValuePair x = (NameValuePair)this.get(i);
            if (!this.eq(x.getName(), name)) continue;
            return CollectionUtils.optional((Object)x);
        }
        return CollectionUtils.empty();
    }

    public Optional<NameValuePair> get(String name) {
        NameValuePair first = null;
        List rest = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            NameValuePair x = (NameValuePair)iterator.next();
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list((Object[])new NameValuePair[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return CollectionUtils.empty();
        }
        if (rest == null) {
            return CollectionUtils.optional(first);
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (NameValuePair element : rest) {
            sb.append(',');
            sb.append(element.getValue());
        }
        return CollectionUtils.optional((Object)new BasicStringPart(name, sb.toString()));
    }

    public <T> Optional<T> get(String name, Class<T> type) {
        NameValuePair first = null;
        List rest = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            NameValuePair x = (NameValuePair)iterator.next();
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list((Object[])new NameValuePair[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return CollectionUtils.empty();
        }
        if (rest == null) {
            return CollectionUtils.optional(PartBeanMeta.of(type).construct(name, first.getValue()));
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (NameValuePair element : rest) {
            sb.append(',');
            sb.append(element.getValue());
        }
        return CollectionUtils.optional(PartBeanMeta.of(type).construct(name, sb.toString()));
    }

    public <T> Optional<T> get(Class<T> type) {
        ArgUtils.assertArgNotNull((String)"type", type);
        String name = PartBeanMeta.of(type).getSchema().getName();
        ArgUtils.assertArg((name != null ? 1 : 0) != 0, (String)"Part name could not be found on bean type ''{0}''", (Object[])new Object[]{type.getName()});
        return this.get(name, type);
    }

    public NameValuePair[] getAll() {
        return (NameValuePair[])this.stream().toArray(NameValuePair[]::new);
    }

    public NameValuePair[] getAll(String name) {
        return (NameValuePair[])this.stream().filter(x -> this.eq(x.getName(), name)).toArray(NameValuePair[]::new);
    }

    public PartList forEachValue(Predicate<NameValuePair> filter, Consumer<String> action) {
        return this.forEach(filter, (NameValuePair x) -> action.accept(x.getValue()));
    }

    public PartList forEachValue(String name, Consumer<String> action) {
        return this.forEach(name, (NameValuePair x) -> action.accept(x.getValue()));
    }

    public String[] getValues(String name) {
        return (String[])this.stream().filter(x -> this.eq(x.getName(), name)).map(NameValuePair::getValue).toArray(String[]::new);
    }

    public boolean contains(String name) {
        return this.stream().anyMatch(x -> this.eq(x.getName(), name));
    }

    public PartIterator partIterator() {
        return new BasicPartIterator((NameValuePair[])this.toArray(new NameValuePair[0]), null, this.caseInsensitive);
    }

    public PartIterator partIterator(String name) {
        return new BasicPartIterator(this.getAll(name), name, this.caseInsensitive);
    }

    public PartList forEach(String name, Consumer<NameValuePair> action) {
        return this.forEach((NameValuePair x) -> this.eq(name, x.getName()), action);
    }

    public PartList forEach(Predicate<NameValuePair> filter, Consumer<NameValuePair> action) {
        this.forEach(x -> ConsumerUtils.consume((Predicate)filter, (Consumer)action, (Object)x));
        return this;
    }

    public Stream<NameValuePair> stream(String name) {
        return this.stream().filter(x -> this.eq(name, x.getName()));
    }

    private NameValuePair createPart(String name, Object value) {
        boolean isResolving;
        boolean bl = isResolving = this.varResolver != null;
        if (value instanceof Supplier) {
            Supplier value2 = (Supplier)value;
            return isResolving ? new BasicPart(name, this.resolver(value2)) : new BasicPart(name, value2);
        }
        return isResolving ? new BasicPart(name, this.resolver(value)) : new BasicPart(name, value);
    }

    private Supplier<Object> resolver(Object input) {
        return () -> this.varResolver.resolve(StringUtils.stringify((Object)this.unwrap(input)));
    }

    private Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        return o;
    }

    private boolean eq(String s1, String s2) {
        return this.caseInsensitive ? StringUtils.eqic((String)s1, (String)s2) : StringUtils.eq((String)s1, (String)s2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.forEach(p -> {
            String v;
            if (p != null && (v = p.getValue()) != null) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(StringUtils.urlEncode((String)p.getName())).append('=').append(StringUtils.urlEncode((String)p.getValue()));
            }
        });
        return sb.toString();
    }

    public PartList setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }

    public static final class Void
    extends PartList {
        private static final long serialVersionUID = 1L;
    }
}

