/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;

public class PartBeanMeta<T> {
    private static final ConcurrentHashMap<Class<?>, PartBeanMeta<?>> CACHE = new ConcurrentHashMap();
    private final Class<T> type;
    private final Constructor<T> constructor;
    private final HttpPartSchema schema;

    public static <T> PartBeanMeta<T> of(Class<T> type) {
        PartBeanMeta<Object> m = CACHE.get(type);
        if (m == null) {
            m = new PartBeanMeta<T>(type);
            CACHE.put(type, m);
        }
        return m;
    }

    private PartBeanMeta(Class<T> type) {
        this.type = type;
        ClassInfo ci = ClassInfo.of(type);
        ConstructorInfo cci = ci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{String.class}));
        if (cci == null) {
            cci = ci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{Object.class}));
        }
        if (cci == null) {
            cci = ci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{String.class, String.class}));
        }
        if (cci == null) {
            cci = ci.getPublicConstructor(x -> x.hasParamTypes(new Class[]{String.class, Object.class}));
        }
        Constructor constructor = this.constructor = cci == null ? null : cci.inner();
        this.schema = ci.hasAnnotation(Query.class) ? HttpPartSchema.create(Query.class, type) : (ci.hasAnnotation(FormData.class) ? HttpPartSchema.create(FormData.class, type) : (ci.hasAnnotation(Path.class) ? HttpPartSchema.create(Path.class, type) : HttpPartSchema.create(Header.class, type)));
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    public T construct(Object value) {
        return this.construct(null, value);
    }

    public T construct(String name, Object value) {
        if (this.constructor == null) {
            throw new UnsupportedOperationException("Constructor for type " + this.type.getName() + " could not be found.");
        }
        if (name == null) {
            name = this.schema.getName();
        }
        Class<?>[] pt = this.constructor.getParameterTypes();
        Object[] args = new Object[pt.length];
        if (pt.length == 1) {
            args[0] = pt[0] == String.class ? StringUtils.stringify((Object)value) : value;
        } else {
            if (name == null) {
                throw new UnsupportedOperationException("Constructor for type " + this.type.getName() + " requires a name as the first argument.");
            }
            args[0] = name;
            args[1] = pt[1] == String.class ? StringUtils.stringify((Object)value) : value;
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw ThrowableUtils.asRuntimeException((Throwable)e);
        }
    }
}

