/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.internal.CollectionUtils;

public class BasicStringPart
extends BasicPart {
    private final String value;
    private final Supplier<String> supplier;

    public static BasicStringPart of(String name, String value) {
        if (StringUtils.isEmpty((String)name) || value == null) {
            return null;
        }
        return new BasicStringPart(name, value);
    }

    public static BasicStringPart of(String name, Supplier<String> value) {
        if (StringUtils.isEmpty((String)name) || value == null) {
            return null;
        }
        return new BasicStringPart(name, value);
    }

    public BasicStringPart(String name, String value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicStringPart(String name, Supplier<String> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public FluentStringAssertion<BasicStringPart> assertString() {
        return new FluentStringAssertion(this.value(), (Object)this);
    }

    @Override
    public String getValue() {
        return this.value();
    }

    public Optional<String> asString() {
        return CollectionUtils.optional((Object)this.value());
    }

    public String orElse(String other) {
        String x = this.value();
        return x != null ? x : other;
    }

    private String value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

