/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Map;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.Headerable;
import org.apache.juneau.http.part.NameValuePairable;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.reflect.ClassInfo;

@FluentSetters
@BeanIgnore
public class BasicPart
implements NameValuePair,
Headerable {
    private final String name;
    private final Object value;

    public static BasicPart of(String name, Object value) {
        return new BasicPart(name, value);
    }

    public static BasicPart ofPair(String pair) {
        if (pair == null) {
            return null;
        }
        int i = pair.indexOf(58);
        if (i == -1) {
            i = pair.indexOf(61);
        }
        if (i == -1) {
            return BasicPart.of(pair, "");
        }
        return BasicPart.of(pair.substring(0, i).trim(), pair.substring(i + 1).trim());
    }

    public static NameValuePair cast(Object o) {
        if (o instanceof NameValuePair) {
            return (NameValuePair)o;
        }
        if (o instanceof NameValuePairable) {
            return ((NameValuePairable)o).asNameValuePair();
        }
        if (o instanceof NameValuePair) {
            NameValuePair p = (NameValuePair)o;
            return BasicPart.of(p.getName(), p.getValue());
        }
        if (o instanceof Headerable) {
            Header x = ((Headerable)o).asHeader();
            return BasicPart.of(x.getName(), x.getValue());
        }
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return BasicPart.of(StringUtils.stringify(e.getKey()), e.getValue());
        }
        throw new BasicRuntimeException("Object of type {0} could not be converted to a Part.", new Object[]{ClassUtils.className((Object)o)});
    }

    public static boolean canCast(Object o) {
        ClassInfo ci = ClassInfo.of((Object)o);
        return ci != null && ci.isChildOfAny(new Class[]{Headerable.class, NameValuePair.class, NameValuePairable.class, Map.Entry.class});
    }

    public BasicPart(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    protected BasicPart(BasicPart copyFrom) {
        ArgUtils.assertArgNotNull((String)"copyFrom", (Object)copyFrom);
        this.name = copyFrom.name;
        this.value = copyFrom.value;
    }

    public FluentStringAssertion<BasicPart> assertName() {
        return new FluentStringAssertion(this.getName(), (Object)this);
    }

    public FluentStringAssertion<BasicPart> assertValue() {
        return new FluentStringAssertion(this.getValue(), (Object)this);
    }

    @Override
    public BasicHeader asHeader() {
        return BasicHeader.of(this.name, StringUtils.stringify((Object)this.value));
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return StringUtils.stringify((Object)this.unwrap(this.value));
    }

    public Object getRawValue() {
        return this.unwrap(this.value);
    }

    public String toString() {
        return this.getName() + "=" + this.getValue();
    }

    private Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        return o;
    }
}

