/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.internal.CollectionUtils;

public class BasicDatePart
extends BasicPart {
    private final ZonedDateTime value;
    private final Supplier<ZonedDateTime> supplier;

    public static BasicDatePart of(String name, ZonedDateTime value) {
        if (StringUtils.isEmpty((String)name) || value == null) {
            return null;
        }
        return new BasicDatePart(name, value);
    }

    public static BasicDatePart of(String name, Supplier<ZonedDateTime> value) {
        if (StringUtils.isEmpty((String)name) || value == null) {
            return null;
        }
        return new BasicDatePart(name, value);
    }

    public BasicDatePart(String name, ZonedDateTime value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicDatePart(String name, Supplier<ZonedDateTime> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public BasicDatePart(String name, String value) {
        super(name, value);
        this.value = StringUtils.isEmpty((String)value) ? null : ZonedDateTime.from(DateTimeFormatter.ISO_DATE_TIME.parse(value)).truncatedTo(ChronoUnit.SECONDS);
        this.supplier = null;
    }

    @Override
    public String getValue() {
        ZonedDateTime v = this.value();
        return v == null ? null : DateTimeFormatter.ISO_DATE_TIME.format(v);
    }

    public Optional<ZonedDateTime> asZonedDateTime() {
        return CollectionUtils.optional((Object)this.toZonedDateTime());
    }

    public ZonedDateTime toZonedDateTime() {
        return this.value();
    }

    public FluentZonedDateTimeAssertion<BasicDatePart> assertZonedDateTime() {
        return new FluentZonedDateTimeAssertion(this.value(), (Object)this);
    }

    public ZonedDateTime orElse(ZonedDateTime other) {
        ZonedDateTime x = this.value();
        return x != null ? x : other;
    }

    private ZonedDateTime value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

