/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentBooleanAssertion;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.part.BasicPart;
import org.apache.juneau.internal.CollectionUtils;

public class BasicBooleanPart
extends BasicPart {
    private final Boolean value;
    private final Supplier<Boolean> supplier;

    public static BasicBooleanPart of(String name, Boolean value) {
        if (StringUtils.isEmpty((String)name) || value == null) {
            return null;
        }
        return new BasicBooleanPart(name, value);
    }

    public static BasicBooleanPart of(String name, Supplier<Boolean> value) {
        if (StringUtils.isEmpty((String)name) || value == null) {
            return null;
        }
        return new BasicBooleanPart(name, value);
    }

    public BasicBooleanPart(String name, Boolean value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicBooleanPart(String name, Supplier<Boolean> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public BasicBooleanPart(String name, String value) {
        super(name, value);
        this.value = StringUtils.isEmpty((String)value) ? null : Boolean.valueOf(value);
        this.supplier = null;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify((Object)this.value());
    }

    public Optional<Boolean> asBoolean() {
        return CollectionUtils.optional((Object)this.toBoolean());
    }

    public Boolean toBoolean() {
        return this.value();
    }

    public FluentBooleanAssertion<BasicBooleanPart> assertBoolean() {
        return new FluentBooleanAssertion(this.value(), (Object)this);
    }

    public Boolean orElse(Boolean other) {
        Boolean x = this.value();
        return x != null ? x : other;
    }

    private Boolean value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

