/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.serializer.SerializeException;

public class SerializedHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final Object value;
    private final Supplier<Object> supplier;
    private HttpPartSerializerSession serializer;
    private HttpPartSchema schema = HttpPartSchema.DEFAULT;
    private boolean skipIfEmpty;

    public static SerializedHeader of(String name, Object value) {
        return new SerializedHeader(name, value, null, null, false);
    }

    public static SerializedHeader of(String name, Supplier<?> value) {
        return new SerializedHeader(name, value, null, null, false);
    }

    public static SerializedHeader of(String name, Object value, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        return new SerializedHeader(name, value, serializer, schema, skipIfEmpty);
    }

    public static SerializedHeader of(String name, Supplier<?> value, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        return new SerializedHeader(name, value, serializer, schema, skipIfEmpty);
    }

    public SerializedHeader(String name, Object value, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        super(name, null);
        this.value = value instanceof Supplier ? null : value;
        this.supplier = value instanceof Supplier ? (Supplier)value : null;
        this.serializer = serializer;
        this.schema = schema;
        this.skipIfEmpty = skipIfEmpty;
    }

    public SerializedHeader(String name, Supplier<Object> value, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        super(name, null);
        this.value = null;
        this.supplier = value;
        this.serializer = serializer;
        this.schema = schema;
        this.skipIfEmpty = skipIfEmpty;
    }

    protected SerializedHeader(SerializedHeader copyFrom) {
        super(copyFrom);
        this.value = copyFrom.value;
        this.supplier = copyFrom.supplier;
        this.serializer = copyFrom.serializer == null ? this.serializer : copyFrom.serializer;
        this.schema = copyFrom.schema == null ? this.schema : copyFrom.schema;
        this.skipIfEmpty = copyFrom.skipIfEmpty;
    }

    public SerializedHeader copy() {
        return new SerializedHeader(this);
    }

    public SerializedHeader serializer(HttpPartSerializer value) {
        if (value != null) {
            return this.serializer(value.getPartSession());
        }
        return this;
    }

    public SerializedHeader serializer(HttpPartSerializerSession value) {
        this.serializer = value;
        return this;
    }

    public SerializedHeader schema(HttpPartSchema value) {
        this.schema = value;
        return this;
    }

    public SerializedHeader copyWith(HttpPartSerializerSession serializer, HttpPartSchema schema) {
        if (this.serializer == null && serializer != null || this.schema == null && schema != null) {
            SerializedHeader h = this.copy();
            if (serializer != null) {
                h.serializer(serializer);
            }
            if (schema != null) {
                h.schema(schema);
            }
            return h;
        }
        return this;
    }

    public SerializedHeader skipIfEmpty() {
        return this.skipIfEmpty(true);
    }

    public SerializedHeader skipIfEmpty(boolean value) {
        this.skipIfEmpty = value;
        return this;
    }

    @Override
    public String getValue() {
        try {
            Object v = this.value;
            if (this.supplier != null) {
                v = this.supplier.get();
            }
            HttpPartSchema schema = this.schema == null ? HttpPartSchema.DEFAULT : this.schema;
            String def = schema.getDefault();
            if (v == null && (def == null && !schema.isRequired() || def == null && schema.isAllowEmptyValue())) {
                return null;
            }
            if (StringUtils.isEmpty((String)StringUtils.stringify((Object)v)) && this.skipIfEmpty && def == null) {
                return null;
            }
            return this.serializer == null ? StringUtils.stringify((Object)v) : this.serializer.serialize(HttpPartType.HEADER, schema, v);
        }
        catch (SchemaValidationException e) {
            throw new BasicRuntimeException((Throwable)e, "Validation error on request {0} parameter ''{1}''=''{2}''", new Object[]{HttpPartType.HEADER, this.getName(), this.value});
        }
        catch (SerializeException e) {
            throw new BasicRuntimeException((Throwable)e, "Serialization error on request {0} parameter ''{1}''", new Object[]{HttpPartType.HEADER, this.getName()});
        }
    }
}

