/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicDateHeader;
import org.apache.juneau.http.header.EntityTag;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;

@Header(value="If-Range")
public class IfRange
extends BasicDateHeader {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "If-Range";
    private final EntityTag value;
    private final Supplier<?> supplier;

    public static IfRange of(String value) {
        return value == null ? null : new IfRange(value);
    }

    public static IfRange of(ZonedDateTime value) {
        return value == null ? null : new IfRange(value);
    }

    public static IfRange of(EntityTag value) {
        return value == null ? null : new IfRange(value);
    }

    public static IfRange of(Supplier<?> value) {
        return value == null ? null : new IfRange(value);
    }

    public IfRange(String value) {
        super(NAME, IfRange.isEtag(value) ? null : value);
        this.value = IfRange.isEtag(value) ? EntityTag.of(value) : null;
        this.supplier = null;
    }

    public IfRange(ZonedDateTime value) {
        super(NAME, value);
        this.value = null;
        this.supplier = null;
    }

    public IfRange(EntityTag value) {
        super(NAME, (String)null);
        this.value = value;
        this.supplier = null;
    }

    public IfRange(Supplier<?> value) {
        super(NAME, (String)null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        if (this.supplier != null) {
            Object o = this.supplier.get();
            if (o == null) {
                return null;
            }
            if (o instanceof EntityTag) {
                return o.toString();
            }
            if (o instanceof ZonedDateTime) {
                return DateTimeFormatter.RFC_1123_DATE_TIME.format((ZonedDateTime)o);
            }
            throw new BasicRuntimeException("Invalid object type returned by supplier: {0}", new Object[]{ClassUtils.className(o)});
        }
        if (this.value != null) {
            return StringUtils.stringify((Object)this.value);
        }
        return super.getValue();
    }

    public Optional<EntityTag> asEntityTag() {
        if (this.supplier != null) {
            Object o = this.supplier.get();
            return CollectionUtils.optional((Object)(o instanceof EntityTag ? (EntityTag)o : null));
        }
        return CollectionUtils.optional((Object)this.value);
    }

    private static boolean isEtag(String s) {
        return s.startsWith("\"") || s.startsWith("W/");
    }
}

