/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.NameValuePair;
import org.apache.http.util.CharArrayBuffer;
import org.apache.juneau.collections.ControlledArrayList;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.BasicHeaderIterator;
import org.apache.juneau.http.header.HeaderBeanMeta;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConsumerUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.svl.VarResolver;

@FluentSetters
public class HeaderList
extends ControlledArrayList<Header> {
    private static final long serialVersionUID = 1L;
    private VarResolver varResolver;
    boolean caseSensitive;

    public static HeaderList create() {
        return new HeaderList();
    }

    public static HeaderList of(List<Header> headers) {
        return new HeaderList().append(headers);
    }

    public static HeaderList of(Header ... headers) {
        return new HeaderList().append(headers);
    }

    public static HeaderList ofPairs(String ... pairs) {
        HeaderList x = new HeaderList();
        if (pairs == null) {
            pairs = new String[]{};
        }
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Odd number of parameters passed into HeaderList.ofPairs()");
        }
        for (int i = 0; i < pairs.length; i += 2) {
            x.add(BasicHeader.of(pairs[i], pairs[i + 1]));
        }
        return x;
    }

    public HeaderList() {
        super(false);
    }

    protected HeaderList(HeaderList copyFrom) {
        super(false, (List)((Object)copyFrom));
        this.caseSensitive = copyFrom.caseSensitive;
    }

    public HeaderList copy() {
        return new HeaderList(this);
    }

    public HeaderList setDefault(List<Header> headers) {
        if (headers != null) {
            headers.stream().filter(x -> x != null && !this.contains(x.getName())).forEach(this::set);
        }
        return this;
    }

    public HeaderList setDefault(String name, Object value) {
        return this.setDefault(this.createPart(name, value));
    }

    public HeaderList setDefault(String name, Supplier<?> value) {
        return this.setDefault(this.createPart(name, value));
    }

    public HeaderList setDefault(Header ... headers) {
        if (headers != null) {
            this.setDefault(Arrays.asList(headers));
        }
        return this;
    }

    public HeaderList resolving() {
        return this.resolving(VarResolver.DEFAULT);
    }

    public HeaderList resolving(VarResolver varResolver) {
        this.assertModifiable();
        this.varResolver = varResolver;
        return this;
    }

    public HeaderList caseSensitive(boolean value) {
        this.assertModifiable();
        this.caseSensitive = value;
        return this;
    }

    @FluentSetter
    public HeaderList append(Header value) {
        if (value != null) {
            this.add(value);
        }
        return this;
    }

    public HeaderList append(String name, Object value) {
        return this.append(this.createPart(name, value));
    }

    public HeaderList append(String name, Supplier<?> value) {
        return this.append(this.createPart(name, value));
    }

    @FluentSetter
    public HeaderList append(Header ... values) {
        if (values != null) {
            for (Header value : values) {
                if (value == null) continue;
                this.append(value);
            }
        }
        return this;
    }

    @FluentSetter
    public HeaderList append(List<Header> values) {
        if (values != null) {
            values.forEach(this::append);
        }
        return this;
    }

    @FluentSetter
    public HeaderList prepend(Header value) {
        if (value != null) {
            this.add(0, value);
        }
        return this;
    }

    public HeaderList prepend(String name, Object value) {
        return this.prepend(this.createPart(name, value));
    }

    public HeaderList prepend(String name, Supplier<?> value) {
        return this.prepend(this.createPart(name, value));
    }

    @FluentSetter
    public HeaderList prepend(Header ... values) {
        if (values != null) {
            this.prepend(CollectionUtils.alist((Object[])values));
        }
        return this;
    }

    @FluentSetter
    public HeaderList prepend(List<Header> values) {
        if (values != null) {
            this.addAll(0, values);
        }
        return this;
    }

    @FluentSetter
    public HeaderList remove(Header value) {
        if (value != null) {
            this.removeIf(x -> this.eq(x.getName(), value.getName()) && this.eq(x.getValue(), value.getValue()));
        }
        return this;
    }

    @FluentSetter
    public HeaderList remove(Header ... values) {
        for (Header value : values) {
            this.remove(value);
        }
        return this;
    }

    @FluentSetter
    public HeaderList remove(List<Header> values) {
        if (values != null) {
            values.forEach(this::remove);
        }
        return this;
    }

    @FluentSetter
    public HeaderList remove(String name) {
        this.removeIf(x -> this.eq(x.getName(), name));
        return this;
    }

    @FluentSetter
    public HeaderList remove(String ... names) {
        if (names != null) {
            for (String name : names) {
                this.remove(name);
            }
        }
        return this;
    }

    public HeaderList removeAll() {
        this.clear();
        return this;
    }

    @FluentSetter
    public HeaderList set(Header value) {
        if (value != null) {
            boolean replaced = false;
            int j = this.size();
            for (int i = 0; i < j; ++i) {
                Header x = (Header)this.get(i);
                if (!this.eq(x.getName(), value.getName())) continue;
                if (replaced) {
                    this.remove(i);
                    --j;
                    continue;
                }
                this.set(i, value);
                replaced = true;
            }
            if (!replaced) {
                this.add(value);
            }
        }
        return this;
    }

    @FluentSetter
    public HeaderList set(Header ... values) {
        if (values != null) {
            this.set(CollectionUtils.alist((Object[])values));
        }
        return this;
    }

    public HeaderList set(String name, Object value) {
        return this.set(this.createPart(name, value));
    }

    public HeaderList set(String name, Supplier<?> value) {
        return this.set(this.createPart(name, value));
    }

    @FluentSetter
    public HeaderList set(List<Header> values) {
        if (values != null) {
            for (Header h : values) {
                if (h == null) continue;
                int j2 = this.size();
                for (int i2 = 0; i2 < j2; ++i2) {
                    Header x = (Header)this.get(i2);
                    if (!this.eq(x.getName(), h.getName())) continue;
                    this.remove(i2);
                    --j2;
                }
            }
            for (Header x : values) {
                if (x == null) continue;
                this.add(x);
            }
        }
        return this;
    }

    public Optional<Header> getFirst(String name) {
        for (int i = 0; i < this.size(); ++i) {
            Header x = (Header)this.get(i);
            if (!this.eq(x.getName(), name)) continue;
            return CollectionUtils.optional((Object)x);
        }
        return CollectionUtils.empty();
    }

    public Optional<Header> getLast(String name) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Header x = (Header)this.get(i);
            if (!this.eq(x.getName(), name)) continue;
            return CollectionUtils.optional((Object)x);
        }
        return CollectionUtils.empty();
    }

    public Optional<Header> get(String name) {
        Header first = null;
        List rest = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Header x = (Header)iterator.next();
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list((Object[])new Header[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return CollectionUtils.empty();
        }
        if (rest == null) {
            return CollectionUtils.optional(first);
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (Header element : rest) {
            sb.append(", ");
            sb.append(element.getValue());
        }
        return CollectionUtils.optional((Object)new BasicHeader(name, sb.toString()));
    }

    public <T> Optional<T> get(String name, Class<T> type) {
        Header first = null;
        List rest = null;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Header x = (Header)iterator.next();
            if (!this.eq(x.getName(), name)) continue;
            if (first == null) {
                first = x;
                continue;
            }
            if (rest == null) {
                rest = CollectionUtils.list((Object[])new Header[0]);
            }
            rest.add(x);
        }
        if (first == null) {
            return CollectionUtils.empty();
        }
        if (rest == null) {
            return CollectionUtils.optional(HeaderBeanMeta.of(type).construct(name, first.getValue()));
        }
        CharArrayBuffer sb = new CharArrayBuffer(128);
        sb.append(first.getValue());
        for (Header element : rest) {
            sb.append(", ");
            sb.append(element.getValue());
        }
        return CollectionUtils.optional(HeaderBeanMeta.of(type).construct(name, sb.toString()));
    }

    public <T> Optional<T> get(Class<T> type) {
        ArgUtils.assertArgNotNull((String)"type", type);
        String name = HeaderBeanMeta.of(type).getSchema().getName();
        ArgUtils.assertArg((name != null ? 1 : 0) != 0, (String)"Header name could not be found on bean type ''{0}''", (Object[])new Object[]{type.getName()});
        return this.get(name, type);
    }

    public Header[] getAll() {
        return (Header[])this.stream().toArray(Header[]::new);
    }

    public Header[] getAll(String name) {
        return (Header[])this.stream().filter(x -> this.eq(x.getName(), name)).toArray(Header[]::new);
    }

    public HeaderList forEachValue(Predicate<Header> filter, Consumer<String> action) {
        return this.forEach(filter, (Header x) -> action.accept(x.getValue()));
    }

    public HeaderList forEachValue(String name, Consumer<String> action) {
        return this.forEach(name, (Header x) -> action.accept(x.getValue()));
    }

    public String[] getValues(String name) {
        return (String[])this.stream().filter(x -> this.eq(x.getName(), name)).map(NameValuePair::getValue).toArray(String[]::new);
    }

    public boolean contains(String name) {
        return this.stream().anyMatch(x -> this.eq(x.getName(), name));
    }

    public HeaderIterator headerIterator() {
        return new BasicHeaderIterator((Header[])this.toArray(new Header[0]), null, this.caseSensitive);
    }

    public HeaderIterator headerIterator(String name) {
        return new BasicHeaderIterator(this.getAll(name), name, this.caseSensitive);
    }

    public HeaderList forEach(String name, Consumer<Header> action) {
        return this.forEach((Header x) -> this.eq(name, x.getName()), action);
    }

    public HeaderList forEach(Predicate<Header> filter, Consumer<Header> action) {
        this.forEach(x -> ConsumerUtils.consume((Predicate)filter, (Consumer)action, (Object)x));
        return this;
    }

    public Stream<Header> stream(String name) {
        return this.stream().filter(x -> this.eq(name, x.getName()));
    }

    private Header createPart(String name, Object value) {
        boolean isResolving;
        boolean bl = isResolving = this.varResolver != null;
        if (value instanceof Supplier) {
            Supplier value2 = (Supplier)value;
            return isResolving ? new BasicHeader(name, this.resolver(value2)) : new BasicHeader(name, (Object)value2);
        }
        return isResolving ? new BasicHeader(name, this.resolver(value)) : new BasicHeader(name, value);
    }

    private Supplier<Object> resolver(Object input) {
        return () -> this.varResolver.resolve(StringUtils.stringify((Object)this.unwrap(input)));
    }

    private Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        return o;
    }

    private boolean eq(String s1, String s2) {
        return this.caseSensitive ? StringUtils.eq((String)s1, (String)s2) : StringUtils.eqic((String)s1, (String)s2);
    }

    public String toString() {
        return "[" + StringUtils.join((List)((Object)this), (String)", ") + "]";
    }

    public HeaderList setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }

    public static final class Void
    extends HeaderList {
        private static final long serialVersionUID = 1L;
    }
}

