/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.ObjectUtils;

public class EntityTag {
    private final String value;
    private final boolean isWeak;
    private final boolean isAny;

    public static EntityTag of(Object value) {
        Object o = ObjectUtils.unwrap((Object)value);
        return o == null ? null : new EntityTag(o.toString());
    }

    public EntityTag(String value) {
        ArgUtils.assertArgNotNull((String)"value", (Object)value);
        value = StringUtils.trim((String)StringUtils.emptyIfNull((String)value));
        this.isWeak = value.startsWith("W/");
        this.isAny = "*".equals(value);
        if (!this.isAny) {
            if (this.isWeak) {
                value = value.substring(2);
            }
            if (value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1);
            } else {
                throw new IllegalArgumentException("Invalid value for entity-tag: [" + (String)(this.isWeak ? "W/" + value : value) + "]");
            }
        }
        this.value = value;
    }

    public String getEntityValue() {
        return this.value;
    }

    public boolean isWeak() {
        return this.isWeak;
    }

    public boolean isAny() {
        return this.isAny;
    }

    public String toString() {
        return (this.isWeak ? "W/" : "") + (String)(this.isAny() ? "*" : "\"" + this.value + "\"");
    }
}

