/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.StringRange;
import org.apache.juneau.StringRanges;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.CollectionUtils;

public class BasicStringRangesHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final StringRanges value;
    private final Supplier<StringRanges> supplier;

    public static BasicStringRangesHeader of(String name, String value) {
        return value == null ? null : new BasicStringRangesHeader(name, value);
    }

    public static BasicStringRangesHeader of(String name, StringRanges value) {
        return value == null ? null : new BasicStringRangesHeader(name, value);
    }

    public static BasicStringRangesHeader of(String name, Supplier<StringRanges> value) {
        return value == null ? null : new BasicStringRangesHeader(name, value);
    }

    public BasicStringRangesHeader(String name, String value) {
        super(name, value);
        this.stringValue = value;
        this.value = StringRanges.of((String)value);
        this.supplier = null;
    }

    public BasicStringRangesHeader(String name, StringRanges value) {
        super(name, StringUtils.stringify((Object)value));
        this.stringValue = null;
        this.value = value;
        this.supplier = null;
    }

    public BasicStringRangesHeader(String name, Supplier<StringRanges> value) {
        super(name, null);
        this.stringValue = null;
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return this.stringValue != null ? this.stringValue : StringUtils.stringify((Object)this.value());
    }

    public Optional<StringRanges> asStringRanges() {
        return CollectionUtils.optional((Object)this.value());
    }

    public StringRanges toStringRanges() {
        return this.value();
    }

    public int match(List<String> names) {
        StringRanges x = this.value();
        return x == null ? -1 : x.match(names);
    }

    public StringRange getRange(int index) {
        StringRanges x = this.value();
        return x == null ? null : x.getRange(index);
    }

    public StringRanges orElse(StringRanges other) {
        StringRanges x = this.value();
        return x != null ? x : other;
    }

    private StringRanges value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

