/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.CollectionUtils;

public class BasicStringHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Supplier<String> supplier;

    public static BasicStringHeader of(String name, String value) {
        return value == null ? null : new BasicStringHeader(name, value);
    }

    public static BasicStringHeader of(String name, Supplier<String> value) {
        return value == null ? null : new BasicStringHeader(name, value);
    }

    public static BasicStringHeader ofPair(String pair) {
        if (pair == null) {
            return null;
        }
        int i = pair.indexOf(58);
        if (i == -1) {
            i = pair.indexOf(61);
        }
        if (i == -1) {
            return BasicStringHeader.of(pair, "");
        }
        return BasicStringHeader.of(pair.substring(0, i).trim(), pair.substring(i + 1).trim());
    }

    public BasicStringHeader(String name, String value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicStringHeader(String name, Supplier<String> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify((Object)this.value());
    }

    @Override
    public Optional<String> asString() {
        return CollectionUtils.optional((Object)this.value());
    }

    public FluentStringAssertion<BasicStringHeader> assertString() {
        return new FluentStringAssertion(this.value(), (Object)this);
    }

    @Override
    public String orElse(String other) {
        String x = this.value();
        return x != null ? x : other;
    }

    private String value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

