/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.CollectionUtils;

@Header
@Schema(type="integer", format="int32")
public class BasicIntegerHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final Integer value;
    private final Supplier<Integer> supplier;

    public static BasicIntegerHeader of(String name, String value) {
        return value == null ? null : new BasicIntegerHeader(name, value);
    }

    public static BasicIntegerHeader of(String name, Integer value) {
        return value == null ? null : new BasicIntegerHeader(name, value);
    }

    public static BasicIntegerHeader of(String name, Supplier<Integer> value) {
        return value == null ? null : new BasicIntegerHeader(name, value);
    }

    public BasicIntegerHeader(String name, String value) {
        super(name, value);
        this.value = this.parse(value);
        this.supplier = null;
    }

    public BasicIntegerHeader(String name, Integer value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicIntegerHeader(String name, Supplier<Integer> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify((Object)this.value());
    }

    public Optional<Integer> asInteger() {
        return CollectionUtils.optional((Object)this.value());
    }

    public Integer toInteger() {
        return this.value();
    }

    public FluentIntegerAssertion<BasicIntegerHeader> assertInteger() {
        return new FluentIntegerAssertion(this.value(), (Object)this);
    }

    public Integer orElse(Integer other) {
        Integer x = this.value();
        return x != null ? x : other;
    }

    private Integer parse(String value) {
        try {
            return value == null ? null : Integer.valueOf(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new BasicRuntimeException("Value ''{0}'' could not be parsed as an integer.", new Object[]{value});
        }
    }

    private Integer value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

