/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;

@FluentSetters
@BeanIgnore
public class BasicHeader
implements Header,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final HeaderElement[] EMPTY_HEADER_ELEMENTS = new HeaderElement[0];
    private final String name;
    private final String stringValue;
    private final Object value;
    private final Supplier<Object> supplier;
    private HeaderElement[] elements;

    public static BasicHeader of(String name, Object value) {
        return value == null ? null : new BasicHeader(name, value);
    }

    public static BasicHeader of(NameValuePair o) {
        return new BasicHeader(o.getName(), o.getValue());
    }

    public BasicHeader(String name, Object value) {
        ArgUtils.assertArg((boolean)StringUtils.isNotEmpty((String)name), (String)"Name cannot be empty on header.", (Object[])new Object[0]);
        this.name = name;
        this.value = value instanceof Supplier ? null : value;
        this.stringValue = StringUtils.stringify((Object)value);
        this.supplier = (Supplier)ObjectUtils.cast(Supplier.class, (Object)value);
    }

    public BasicHeader(String name, Supplier<Object> value) {
        ArgUtils.assertArg((boolean)StringUtils.isNotEmpty((String)name), (String)"Name cannot be empty on header.", (Object[])new Object[0]);
        this.name = name;
        this.value = null;
        this.stringValue = null;
        this.supplier = value;
    }

    protected BasicHeader(BasicHeader copyFrom) {
        this.name = copyFrom.name;
        this.value = copyFrom.value;
        this.stringValue = copyFrom.stringValue;
        this.supplier = copyFrom.supplier;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.supplier != null) {
            return StringUtils.stringify((Object)this.supplier.get());
        }
        return this.stringValue;
    }

    public HeaderElement[] getElements() throws ParseException {
        if (this.elements == null) {
            HeaderElement[] x;
            String s = this.getValue();
            HeaderElement[] headerElementArray = x = s == null ? EMPTY_HEADER_ELEMENTS : BasicHeaderValueParser.parseElements((String)s, null);
            if (this.supplier == null) {
                this.elements = x;
            }
            return x;
        }
        return this.elements;
    }

    public boolean equalsIgnoreCase(String compare) {
        return StringUtils.eqic((String)this.getValue(), (String)compare);
    }

    public FluentStringAssertion<BasicHeader> assertName() {
        return new FluentStringAssertion(this.getName(), (Object)this);
    }

    public FluentStringAssertion<BasicHeader> assertStringValue() {
        return new FluentStringAssertion(this.getValue(), (Object)this);
    }

    public Optional<String> asString() {
        return CollectionUtils.optional((Object)this.getValue());
    }

    public boolean isPresent() {
        return this.asString().isPresent();
    }

    public boolean isNotEmpty() {
        return !this.asString().orElse("").isEmpty();
    }

    public String get() {
        return this.asString().get();
    }

    public String orElse(String other) {
        return this.asString().orElse(other);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Header)) {
            return false;
        }
        return ObjectUtils.eq((Object)this, (Object)((Header)o), (x, y) -> StringUtils.eq((String)x.name, (String)y.getName()) && StringUtils.eq((String)x.getValue(), (String)y.getValue()));
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getName() + ": " + this.getValue();
    }
}

