/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.EntityTags;
import org.apache.juneau.internal.CollectionUtils;

public class BasicEntityTagsHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final EntityTags value;
    private final Supplier<EntityTags> supplier;

    public static BasicEntityTagsHeader of(String name, String value) {
        return value == null ? null : new BasicEntityTagsHeader(name, value);
    }

    public static BasicEntityTagsHeader of(String name, EntityTags value) {
        return value == null ? null : new BasicEntityTagsHeader(name, value);
    }

    public static BasicEntityTagsHeader of(String name, Supplier<EntityTags> value) {
        return value == null ? null : new BasicEntityTagsHeader(name, value);
    }

    public BasicEntityTagsHeader(String name, String value) {
        super(name, value);
        this.value = EntityTags.of(value);
        this.supplier = null;
    }

    public BasicEntityTagsHeader(String name, EntityTags value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicEntityTagsHeader(String name, Supplier<EntityTags> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify((Object)this.value());
    }

    public Optional<EntityTags> asEntityTags() {
        return CollectionUtils.optional((Object)this.value());
    }

    public EntityTags toEntityTags() {
        return this.value();
    }

    public EntityTags orElse(EntityTags other) {
        EntityTags x = this.value();
        return x != null ? x : other;
    }

    private EntityTags value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

