/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.http.header.EntityTag;
import org.apache.juneau.internal.CollectionUtils;

public class BasicEntityTagHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final EntityTag value;
    private final Supplier<EntityTag> supplier;

    public static BasicEntityTagHeader of(String name, String value) {
        return value == null ? null : new BasicEntityTagHeader(name, value);
    }

    public static BasicEntityTagHeader of(String name, EntityTag value) {
        return value == null ? null : new BasicEntityTagHeader(name, value);
    }

    public static BasicEntityTagHeader of(String name, Supplier<EntityTag> value) {
        return value == null ? null : new BasicEntityTagHeader(name, value);
    }

    public BasicEntityTagHeader(String name, String value) {
        super(name, value);
        this.value = EntityTag.of(value);
        this.supplier = null;
    }

    public BasicEntityTagHeader(String name, EntityTag value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicEntityTagHeader(String name, Supplier<EntityTag> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify((Object)this.value());
    }

    public Optional<EntityTag> asEntityTag() {
        return CollectionUtils.optional((Object)this.value());
    }

    public EntityTag toEntityTag() {
        return this.value();
    }

    public EntityTag orElse(EntityTag other) {
        EntityTag x = this.value();
        return x != null ? x : other;
    }

    private EntityTag value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

