/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentZonedDateTimeAssertion;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.CollectionUtils;

public class BasicDateHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final ZonedDateTime value;
    private final Supplier<ZonedDateTime> supplier;

    public static BasicDateHeader of(String name, String value) {
        return value == null ? null : new BasicDateHeader(name, value);
    }

    public static BasicDateHeader of(String name, ZonedDateTime value) {
        return value == null ? null : new BasicDateHeader(name, value);
    }

    public static BasicDateHeader of(String name, Supplier<ZonedDateTime> value) {
        return value == null ? null : new BasicDateHeader(name, value);
    }

    public BasicDateHeader(String name, String value) {
        super(name, value);
        this.value = StringUtils.isEmpty((String)value) ? null : ZonedDateTime.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(value.toString())).truncatedTo(ChronoUnit.SECONDS);
        this.supplier = null;
    }

    public BasicDateHeader(String name, ZonedDateTime value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicDateHeader(String name, Supplier<ZonedDateTime> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        ZonedDateTime x = this.value();
        return x == null ? null : DateTimeFormatter.RFC_1123_DATE_TIME.format(x);
    }

    public Optional<ZonedDateTime> asZonedDateTime() {
        return CollectionUtils.optional((Object)this.value());
    }

    public ZonedDateTime toZonedDateTime() {
        return this.value();
    }

    public FluentZonedDateTimeAssertion<BasicDateHeader> assertZonedDateTime() {
        return new FluentZonedDateTimeAssertion(this.value(), (Object)this);
    }

    public ZonedDateTime orElse(ZonedDateTime other) {
        ZonedDateTime x = this.value();
        return x != null ? x : other;
    }

    private ZonedDateTime value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

