/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;

public class BasicCsvHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final String[] value;
    private final Supplier<String[]> supplier;

    public static BasicCsvHeader of(String name, String value) {
        return value == null ? null : new BasicCsvHeader(name, value);
    }

    public static BasicCsvHeader of(String name, String ... value) {
        return value == null ? null : new BasicCsvHeader(name, value);
    }

    public static BasicCsvHeader of(String name, Supplier<String[]> value) {
        return value == null ? null : new BasicCsvHeader(name, value);
    }

    public BasicCsvHeader(String name, String value) {
        super(name, value);
        this.value = StringUtils.split((String)value);
        this.supplier = null;
    }

    public BasicCsvHeader(String name, String ... value) {
        super(name, StringUtils.join((Object[])value, (String)", "));
        this.value = (String[])ArrayUtils.copyOf((Object[])value);
        this.supplier = null;
    }

    public BasicCsvHeader(String name, Supplier<String[]> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.join((Object[])this.value(), (String)", ");
    }

    public Optional<String[]> asArray() {
        return CollectionUtils.optional((Object)((String[])ArrayUtils.copyOf((Object[])this.value())));
    }

    public String[] toArray() {
        return (String[])ArrayUtils.copyOf((Object[])this.value());
    }

    public Optional<List<String>> asList() {
        return CollectionUtils.optional((Object)CollectionUtils.ulist((Object[])this.value()));
    }

    public List<String> toList() {
        return CollectionUtils.ulist((Object[])this.value());
    }

    public boolean contains(String val) {
        String[] value2;
        if (this.value != null) {
            for (String v : this.value) {
                if (!StringUtils.eq((String)v, (String)val)) continue;
                return true;
            }
        }
        if (this.supplier != null && (value2 = this.supplier.get()) != null) {
            for (String v : this.supplier.get()) {
                if (!StringUtils.eq((String)v, (String)val)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsIgnoreCase(String val) {
        String[] value2;
        if (this.value != null) {
            for (String v : this.value) {
                if (!StringUtils.eqic((String)v, (String)val)) continue;
                return true;
            }
        }
        if (this.supplier != null && (value2 = this.supplier.get()) != null) {
            for (String v : this.supplier.get()) {
                if (!StringUtils.eqic((String)v, (String)val)) continue;
                return true;
            }
        }
        return false;
    }

    public FluentListAssertion<String, BasicCsvHeader> assertList() {
        return new FluentListAssertion(CollectionUtils.ulist((Object[])this.value()), (Object)this);
    }

    public String[] orElse(String[] other) {
        String[] x = this.value();
        return x != null ? x : other;
    }

    private String[] value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

