/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.assertions.FluentBooleanAssertion;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicHeader;
import org.apache.juneau.internal.CollectionUtils;

@Header
@Schema(type="boolean")
public class BasicBooleanHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final Boolean value;
    private final Supplier<Boolean> supplier;

    public static BasicBooleanHeader of(String name, String value) {
        return value == null ? null : new BasicBooleanHeader(name, value);
    }

    public static BasicBooleanHeader of(String name, Boolean value) {
        return value == null ? null : new BasicBooleanHeader(name, value);
    }

    public static BasicBooleanHeader of(String name, Supplier<Boolean> value) {
        return value == null ? null : new BasicBooleanHeader(name, value);
    }

    public BasicBooleanHeader(String name, String value) {
        super(name, value);
        this.value = StringUtils.isEmpty((String)value) ? null : Boolean.valueOf(value);
        this.supplier = null;
    }

    public BasicBooleanHeader(String name, Boolean value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicBooleanHeader(String name, Supplier<Boolean> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    @Override
    public String getValue() {
        return StringUtils.stringify((Object)this.value());
    }

    public Optional<Boolean> asBoolean() {
        return CollectionUtils.optional((Object)this.value());
    }

    public Boolean toBoolean() {
        return this.value();
    }

    public boolean isTrue() {
        Boolean x = this.value();
        return x == null ? this.value : x;
    }

    public FluentBooleanAssertion<BasicBooleanHeader> assertBoolean() {
        return new FluentBooleanAssertion(this.value(), (Object)this);
    }

    public Boolean orElse(Boolean other) {
        Boolean x = this.value();
        return x != null ? x : other;
    }

    private Boolean value() {
        if (this.supplier != null) {
            return this.supplier.get();
        }
        return this.value;
    }
}

