/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters
public class StreamEntity
extends BasicHttpEntity {
    private byte[] byteCache;
    private String stringCache;

    public StreamEntity() {
    }

    public StreamEntity(ContentType contentType, InputStream content) {
        super(contentType, content);
    }

    protected StreamEntity(StreamEntity copyFrom) {
        super(copyFrom);
    }

    @Override
    public StreamEntity copy() {
        return new StreamEntity(this);
    }

    private InputStream content() {
        return Objects.requireNonNull(this.contentOrElse(null), "Input stream is null.");
    }

    @Override
    public String asString() throws IOException {
        if (this.isCached() && this.stringCache == null) {
            this.stringCache = IOUtils.read((InputStream)this.content(), (Charset)this.getCharset());
        }
        if (this.stringCache != null) {
            return this.stringCache;
        }
        return IOUtils.read((InputStream)this.content());
    }

    @Override
    public byte[] asBytes() throws IOException {
        if (this.isCached() && this.byteCache == null) {
            this.byteCache = IOUtils.readBytes((InputStream)this.content(), (int)this.getMaxLength());
        }
        if (this.byteCache != null) {
            return this.byteCache;
        }
        return IOUtils.readBytes((InputStream)this.content(), (int)this.getMaxLength());
    }

    @Override
    public boolean isRepeatable() {
        return this.isCached();
    }

    @Override
    public long getContentLength() {
        if (this.isCached()) {
            return this.asSafeBytes().length;
        }
        return super.getContentLength();
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.isCached()) {
            return new ByteArrayInputStream(this.asBytes());
        }
        return this.content();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        ArgUtils.assertArgNotNull((String)"out", (Object)out);
        if (this.isCached()) {
            out.write(this.asBytes());
        } else {
            try (InputStream is = this.getContent();){
                IOUtils.pipe((InputStream)is, (OutputStream)out, (long)this.getMaxLength());
            }
        }
    }

    @Override
    public boolean isStreaming() {
        return !this.isCached();
    }

    @Override
    public StreamEntity setCached() throws IOException {
        super.setCached();
        return this;
    }

    @Override
    public StreamEntity setCharset(Charset value) {
        super.setCharset(value);
        return this;
    }

    @Override
    public StreamEntity setChunked() {
        super.setChunked();
        return this;
    }

    @Override
    public StreamEntity setChunked(boolean value) {
        super.setChunked(value);
        return this;
    }

    @Override
    public StreamEntity setContent(Object value) {
        super.setContent(value);
        return this;
    }

    @Override
    public StreamEntity setContent(Supplier<?> value) {
        super.setContent(value);
        return this;
    }

    @Override
    public StreamEntity setContentEncoding(String value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public StreamEntity setContentEncoding(ContentEncoding value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public StreamEntity setContentLength(long value) {
        super.setContentLength(value);
        return this;
    }

    @Override
    public StreamEntity setContentType(String value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public StreamEntity setContentType(ContentType value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public StreamEntity setMaxLength(int value) {
        super.setMaxLength(value);
        return this;
    }

    @Override
    public StreamEntity setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }
}

