/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters
public class FileEntity
extends BasicHttpEntity {
    private byte[] byteCache;
    private String stringCache;

    public FileEntity() {
    }

    public FileEntity(ContentType contentType, File content) {
        super(contentType, content);
    }

    protected FileEntity(FileEntity copyFrom) {
        super(copyFrom);
    }

    @Override
    public FileEntity copy() {
        return new FileEntity(this);
    }

    private File content() {
        File f = this.contentOrElse(null);
        Objects.requireNonNull(f, "File");
        if (!f.exists()) {
            throw new IllegalStateException("File " + f.getAbsolutePath() + " does not exist.");
        }
        if (!f.canRead()) {
            throw new IllegalStateException("File " + f.getAbsolutePath() + " is not readable.");
        }
        return f;
    }

    @Override
    public String asString() throws IOException {
        if (this.isCached() && this.stringCache == null) {
            this.stringCache = IOUtils.read((Reader)new InputStreamReader((InputStream)new FileInputStream(this.content()), this.getCharset()), (long)this.getMaxLength());
        }
        if (this.stringCache != null) {
            return this.stringCache;
        }
        return IOUtils.read((Reader)new InputStreamReader((InputStream)new FileInputStream(this.content()), this.getCharset()), (long)this.getMaxLength());
    }

    @Override
    public byte[] asBytes() throws IOException {
        if (this.isCached() && this.byteCache == null) {
            this.byteCache = IOUtils.readBytes((File)this.content(), (int)this.getMaxLength());
        }
        if (this.byteCache != null) {
            return this.byteCache;
        }
        return IOUtils.readBytes((File)this.content());
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.content().length();
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.isCached()) {
            return new ByteArrayInputStream(this.asBytes());
        }
        return new FileInputStream(this.content());
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        ArgUtils.assertArgNotNull((String)"out", (Object)out);
        if (this.isCached()) {
            out.write(this.asBytes());
        } else {
            try (InputStream is = this.getContent();){
                IOUtils.pipe((InputStream)is, (OutputStream)out, (long)this.getMaxLength());
            }
        }
    }

    @Override
    public FileEntity setCached() throws IOException {
        super.setCached();
        return this;
    }

    @Override
    public FileEntity setCharset(Charset value) {
        super.setCharset(value);
        return this;
    }

    @Override
    public FileEntity setChunked() {
        super.setChunked();
        return this;
    }

    @Override
    public FileEntity setChunked(boolean value) {
        super.setChunked(value);
        return this;
    }

    @Override
    public FileEntity setContent(Object value) {
        super.setContent(value);
        return this;
    }

    @Override
    public FileEntity setContent(Supplier<?> value) {
        super.setContent(value);
        return this;
    }

    @Override
    public FileEntity setContentEncoding(String value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public FileEntity setContentEncoding(ContentEncoding value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public FileEntity setContentLength(long value) {
        super.setContentLength(value);
        return this;
    }

    @Override
    public FileEntity setContentType(String value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public FileEntity setContentType(ContentType value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public FileEntity setMaxLength(int value) {
        super.setMaxLength(value);
        return this;
    }

    @Override
    public FileEntity setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }
}

