/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.http.entity.BasicHttpEntity;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters
public class ByteArrayEntity
extends BasicHttpEntity {
    private static final byte[] EMPTY = new byte[0];

    public ByteArrayEntity() {
    }

    public ByteArrayEntity(ContentType contentType, byte[] contents) {
        super(contentType, contents);
    }

    protected ByteArrayEntity(ByteArrayEntity copyFrom) {
        super(copyFrom);
    }

    @Override
    public ByteArrayEntity copy() {
        return new ByteArrayEntity(this);
    }

    private byte[] content() {
        return this.contentOrElse(EMPTY);
    }

    @Override
    public String asString() throws IOException {
        return new String(this.content(), this.getCharset());
    }

    @Override
    public byte[] asBytes() throws IOException {
        return this.content();
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.isSupplied() ? super.getContentLength() : (long)this.content().length;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content());
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        ArgUtils.assertArgNotNull((String)"out", (Object)out);
        out.write(this.content());
    }

    @Override
    public ByteArrayEntity setCached() throws IOException {
        super.setCached();
        return this;
    }

    @Override
    public ByteArrayEntity setCharset(Charset value) {
        super.setCharset(value);
        return this;
    }

    @Override
    public ByteArrayEntity setChunked() {
        super.setChunked();
        return this;
    }

    @Override
    public ByteArrayEntity setChunked(boolean value) {
        super.setChunked(value);
        return this;
    }

    @Override
    public ByteArrayEntity setContent(Object value) {
        super.setContent(value);
        return this;
    }

    @Override
    public ByteArrayEntity setContent(Supplier<?> value) {
        super.setContent(value);
        return this;
    }

    @Override
    public ByteArrayEntity setContentEncoding(String value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public ByteArrayEntity setContentEncoding(ContentEncoding value) {
        super.setContentEncoding(value);
        return this;
    }

    @Override
    public ByteArrayEntity setContentLength(long value) {
        super.setContentLength(value);
        return this;
    }

    @Override
    public ByteArrayEntity setContentType(String value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public ByteArrayEntity setContentType(ContentType value) {
        super.setContentType(value);
        return this;
    }

    @Override
    public ByteArrayEntity setMaxLength(int value) {
        super.setMaxLength(value);
        return this;
    }

    @Override
    public ByteArrayEntity setUnmodifiable() {
        super.setUnmodifiable();
        return this;
    }
}

