/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentByteArrayAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.common.internal.IOUtils;
import org.apache.juneau.http.header.ContentEncoding;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;

@BeanIgnore
@FluentSetters
public class BasicHttpEntity
implements HttpEntity {
    public static final BasicHttpEntity EMPTY = new BasicHttpEntity().setUnmodifiable();
    private boolean cached;
    private boolean chunked;
    private boolean unmodifiable;
    private Object content;
    private Supplier<?> contentSupplier;
    private ContentType contentType;
    private ContentEncoding contentEncoding;
    private Charset charset;
    private long contentLength = -1L;
    private int maxLength = -1;

    public BasicHttpEntity() {
    }

    public BasicHttpEntity(ContentType contentType, Object content) {
        this.contentType = contentType;
        this.content = content;
    }

    public BasicHttpEntity(BasicHttpEntity copyFrom) {
        this.cached = copyFrom.cached;
        this.chunked = copyFrom.chunked;
        this.content = copyFrom.content;
        this.contentSupplier = copyFrom.contentSupplier;
        this.contentType = copyFrom.contentType;
        this.contentEncoding = copyFrom.contentEncoding;
        this.contentLength = copyFrom.contentLength;
        this.charset = copyFrom.charset;
        this.maxLength = copyFrom.maxLength;
        this.unmodifiable = false;
    }

    public BasicHttpEntity copy() {
        return new BasicHttpEntity(this);
    }

    @FluentSetter
    public BasicHttpEntity setUnmodifiable() {
        this.unmodifiable = true;
        return this;
    }

    public boolean isUnmodifiable() {
        return this.unmodifiable;
    }

    protected final void assertModifiable() {
        if (this.unmodifiable) {
            throw new UnsupportedOperationException("Bean is read-only");
        }
    }

    @FluentSetter
    public BasicHttpEntity setContent(Object value) {
        this.assertModifiable();
        this.content = value;
        return this;
    }

    @FluentSetter
    public BasicHttpEntity setContent(Supplier<?> value) {
        this.assertModifiable();
        this.contentSupplier = value == null ? () -> null : value;
        return this;
    }

    @FluentSetter
    public BasicHttpEntity setContentType(String value) {
        return this.setContentType(ContentType.of(value));
    }

    @FluentSetter
    public BasicHttpEntity setContentType(ContentType value) {
        this.assertModifiable();
        this.contentType = value;
        return this;
    }

    @FluentSetter
    public BasicHttpEntity setContentLength(long value) {
        this.assertModifiable();
        this.contentLength = value;
        return this;
    }

    @FluentSetter
    public BasicHttpEntity setContentEncoding(String value) {
        return this.setContentEncoding(ContentEncoding.of(value));
    }

    @FluentSetter
    public BasicHttpEntity setContentEncoding(ContentEncoding value) {
        this.assertModifiable();
        this.contentEncoding = value;
        return this;
    }

    @FluentSetter
    public BasicHttpEntity setChunked() {
        return this.setChunked(true);
    }

    @FluentSetter
    public BasicHttpEntity setChunked(boolean value) {
        this.assertModifiable();
        this.chunked = value;
        return this;
    }

    @FluentSetter
    public BasicHttpEntity setCached() throws IOException {
        this.assertModifiable();
        this.cached = true;
        return this;
    }

    public boolean isCached() {
        return this.cached;
    }

    @FluentSetter
    public BasicHttpEntity setCharset(Charset value) {
        this.assertModifiable();
        this.charset = value;
        return this;
    }

    public Charset getCharset() {
        return this.charset == null ? IOUtils.UTF8 : this.charset;
    }

    @FluentSetter
    public BasicHttpEntity setMaxLength(int value) {
        this.assertModifiable();
        this.maxLength = value;
        return this;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String asString() throws IOException {
        return IOUtils.read((InputStream)this.getContent());
    }

    public byte[] asBytes() throws IOException {
        return IOUtils.readBytes((InputStream)this.getContent());
    }

    protected byte[] asSafeBytes() {
        try {
            return this.asBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public FluentStringAssertion<BasicHttpEntity> assertString() throws IOException {
        return new FluentStringAssertion(this.asString(), (Object)this);
    }

    public FluentByteArrayAssertion<BasicHttpEntity> assertBytes() throws IOException {
        return new FluentByteArrayAssertion(this.asBytes(), (Object)this);
    }

    protected <T> T contentOrElse(T def) {
        Object o = this.content;
        if (o == null && this.contentSupplier != null) {
            o = this.contentSupplier.get();
        }
        return (T)(o == null ? def : o);
    }

    protected boolean isSupplied() {
        return this.contentSupplier != null;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public Header getContentType() {
        return this.contentType;
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public boolean isStreaming() {
        return false;
    }

    public void consumeContent() throws IOException {
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return IOUtils.EMPTY_INPUT_STREAM;
    }

    public void writeTo(OutputStream outStream) throws IOException {
    }
}

